/*
 * Decompiled with CFR 0.152.
 */
package io.shadowstack;

import io.shadowstack.AdapterException;
import io.shadowstack.MethodRouter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class Adapter
implements MethodInterceptor {
    private final Object adaptedInstance;
    private final Map<Method, MethodRouter> methodRouters;

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        MethodRouter router = this.methodRouters.get(method);
        if (router == null) {
            String msg = "No method routing specified for method %s of class %s";
            String cls = this.adaptedInstance.getClass().getSimpleName();
            throw new AdapterException(String.format(msg, method.getName(), cls));
        }
        return router.forward(args, this.adaptedInstance);
    }

    @Generated
    public Object getAdaptedInstance() {
        return this.adaptedInstance;
    }

    @Generated
    public Map<Method, MethodRouter> getMethodRouters() {
        return this.methodRouters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adapter)) {
            return false;
        }
        Adapter other = (Adapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$adaptedInstance = this.getAdaptedInstance();
        Object other$adaptedInstance = other.getAdaptedInstance();
        if (this$adaptedInstance == null ? other$adaptedInstance != null : !this$adaptedInstance.equals(other$adaptedInstance)) {
            return false;
        }
        Map<Method, MethodRouter> this$methodRouters = this.getMethodRouters();
        Map<Method, MethodRouter> other$methodRouters = other.getMethodRouters();
        return !(this$methodRouters == null ? other$methodRouters != null : !((Object)this$methodRouters).equals(other$methodRouters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Adapter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $adaptedInstance = this.getAdaptedInstance();
        result = result * 59 + ($adaptedInstance == null ? 43 : $adaptedInstance.hashCode());
        Map<Method, MethodRouter> $methodRouters = this.getMethodRouters();
        result = result * 59 + ($methodRouters == null ? 43 : ((Object)$methodRouters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Adapter(adaptedInstance=" + this.getAdaptedInstance() + ", methodRouters=" + this.getMethodRouters() + ")";
    }

    @Generated
    public Adapter(Object adaptedInstance, Map<Method, MethodRouter> methodRouters) {
        this.adaptedInstance = adaptedInstance;
        this.methodRouters = methodRouters;
    }

    public static class InnerBuilder<T> {
        private final Object adaptedInstance;
        private final Class<T> exposedInterface;
        private Map<Method, MethodRouter> methodRouters = new HashMap<Method, MethodRouter>();

        public InnerBuilder(Object adaptedInstance, Class<T> exposedInterface) {
            this.adaptedInstance = adaptedInstance;
            this.exposedInterface = exposedInterface;
        }

        public InnerBuilder<T> routing(MethodRouter.Builder ... builders) throws AdapterException, NoSuchMethodException {
            if (builders != null && builders.length > 0) {
                for (MethodRouter.Builder builder : builders) {
                    MethodRouter router = builder.build(this.exposedInterface, this.adaptedInstance.getClass());
                    this.methodRouters.put(router.getMethodFrom(), router);
                }
            }
            return this;
        }

        public T build() throws AdapterException {
            if (this.adaptedInstance == null) {
                throw new AdapterException("Null adapted instance.");
            }
            if (this.exposedInterface == null) {
                throw new AdapterException("Null target class.");
            }
            if (this.methodRouters.size() == 0) {
                throw new AdapterException("No method routers passed to adapter builder.");
            }
            return (T)Enhancer.create(this.exposedInterface, (Callback)new Adapter(this.adaptedInstance, this.methodRouters));
        }
    }

    public static class OuterBuilder {
        private final Object adaptedInstance;

        public <T> InnerBuilder<T> into(Class<T> exposedInterface) {
            return new InnerBuilder<T>(this.adaptedInstance, exposedInterface);
        }

        @Generated
        public OuterBuilder(Object adaptedInstance) {
            this.adaptedInstance = adaptedInstance;
        }
    }
}

