/*
 * Decompiled with CFR 0.152.
 */
package severr;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

class LocalDateTypeAdapter
extends TypeAdapter<LocalDate> {
    private final DateTimeFormatter formatter = ISODateTimeFormat.date();

    LocalDateTypeAdapter() {
    }

    public void write(JsonWriter out, LocalDate date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            out.value(this.formatter.print((ReadablePartial)date));
        }
    }

    public LocalDate read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        String date = in.nextString();
        return this.formatter.parseLocalDate(date);
    }
}

