/*
 * Decompiled with CFR 0.152.
 */
package severr;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import severr.ApiClient;

class DateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final ApiClient apiClient;

    public DateAdapter(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.apiClient.formatDatetime(src));
    }

    public Date deserialize(JsonElement json, Type date, JsonDeserializationContext context) throws JsonParseException {
        String str = json.getAsJsonPrimitive().getAsString();
        try {
            return this.apiClient.parseDateOrDatetime(str);
        }
        catch (RuntimeException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

