/*
 * Decompiled with CFR 0.152.
 */
package io.severr.client;

import com.squareup.okhttp.Call;
import io.severr.EventsApi;
import io.severr.client.EventTraceBuilder;
import io.severr.model.AppEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import severr.ApiCallback;
import severr.ApiClient;
import severr.ApiException;
import severr.ApiResponse;

public class SeverrClient {
    private String apiKey;
    private String contextAppVersion;
    private String contextEnvName;
    private String contextEnvVersion;
    private String contextEnvHostname;
    private String contextAppOS;
    private String contextAppOSVersion;
    private String contextDataCenter;
    private String contextDataCenterRegion;
    private EventsApi eventsApi;

    public SeverrClient(String apiKey, String url, String contextAppVersion, String contextEnvName, String contextEnvVersion, String contextEnvHostname, String contextAppOS, String contextAppOSVersion, String contextDataCenter, String contextDataCenterRegion) {
        this.apiKey = apiKey;
        this.contextAppVersion = contextAppVersion == null ? "1.0" : contextAppVersion;
        this.contextEnvName = contextEnvName == null ? "development" : contextEnvName;
        this.contextEnvVersion = contextEnvVersion;
        try {
            this.contextEnvHostname = contextEnvHostname == null ? InetAddress.getLocalHost().getHostName() : contextEnvHostname;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.contextAppOS = contextAppOS == null ? System.getProperty("os.name") : contextAppOS;
        this.contextAppOSVersion = contextAppOSVersion == null ? System.getProperty("os.version") : contextAppOSVersion;
        this.contextDataCenter = contextDataCenter;
        this.contextDataCenterRegion = contextDataCenterRegion;
        ApiClient client = new ApiClient();
        if (url != null) {
            client.setBasePath(url);
        }
        this.eventsApi = new EventsApi(client);
    }

    public AppEvent createAppEvent(String classification, String eventType, String eventMessage) {
        if (classification == null) {
            classification = "Error";
        }
        if (eventType == null) {
            eventType = "unknown";
        }
        if (eventMessage == null) {
            eventMessage = "unknown";
        }
        AppEvent event = new AppEvent();
        event.setClassification(classification);
        event.setEventType(eventType);
        event.setEventMessage(eventMessage);
        return this.FillDefaults(event);
    }

    public void sendException(String classification, Throwable e) {
        AppEvent event = this.createAppEvent(classification, e.getClass().getName(), e.getMessage());
        event.setEventStacktrace(EventTraceBuilder.getEventTraces(e));
        try {
            this.sendEvent(event);
        }
        catch (ApiException apiException) {
            throw new RuntimeException(apiException.getMessage(), apiException);
        }
    }

    public ApiResponse<Void> sendEvent(AppEvent appEvent) throws ApiException {
        this.FillDefaults(appEvent);
        return this.eventsApi.eventsPostWithHttpInfo(appEvent);
    }

    public Call sendEventAsync(AppEvent appEvent, ApiCallback<Void> callback) throws ApiException {
        this.FillDefaults(appEvent);
        return this.eventsApi.eventsPostAsync(appEvent, callback);
    }

    private AppEvent FillDefaults(AppEvent appEvent) {
        if (appEvent.getApiKey() == null) {
            appEvent.setApiKey(this.apiKey);
        }
        if (appEvent.getContextAppVersion() == null) {
            appEvent.setContextAppVersion(this.contextAppVersion);
        }
        if (appEvent.getContextEnvName() == null) {
            appEvent.setContextEnvName(this.contextEnvName);
        }
        if (appEvent.getContextEnvVersion() == null) {
            appEvent.setContextEnvVersion(this.contextEnvVersion);
        }
        if (appEvent.getContextEnvHostname() == null) {
            appEvent.setContextEnvHostname(this.contextEnvHostname);
        }
        if (appEvent.getContextAppOS() == null) {
            appEvent.setContextAppOS(this.contextAppOS);
            appEvent.setContextAppOSVersion(this.contextAppOSVersion);
        }
        if (appEvent.getContextDataCenter() == null) {
            appEvent.setContextDataCenter(this.contextDataCenter);
        }
        if (appEvent.getContextDataCenterRegion() == null) {
            appEvent.setContextDataCenterRegion(this.contextDataCenterRegion);
        }
        if (appEvent.getEventTime() == null) {
            appEvent.setEventTime(System.currentTimeMillis());
        }
        return appEvent;
    }
}

