/*
 * Decompiled with CFR 0.152.
 */
package io.severr.client;

import io.severr.model.InnerStackTrace;
import io.severr.model.StackTraceLine;
import io.severr.model.StackTraceLines;
import io.severr.model.Stacktrace;
import java.util.List;

class EventTraceBuilder {
    EventTraceBuilder() {
    }

    static Stacktrace getEventTraces(Throwable e) {
        if (e == null) {
            return null;
        }
        Stacktrace traces = new Stacktrace();
        EventTraceBuilder.addStackTraces(traces, e);
        return traces;
    }

    private static void addStackTraces(List<InnerStackTrace> traces, Throwable exception) {
        InnerStackTrace newTrace = new InnerStackTrace();
        newTrace.setTraceLines(EventTraceBuilder.getEventTraceLines(exception));
        newTrace.setType(exception.getClass().getName());
        newTrace.setMessage(exception.getMessage());
        traces.add(newTrace);
        if (exception.getCause() != null) {
            EventTraceBuilder.addStackTraces(traces, exception.getCause());
        }
    }

    private static StackTraceLines getEventTraceLines(Throwable exception) {
        StackTraceLines lines = new StackTraceLines();
        if (exception == null || exception.getStackTrace().length == 0) {
            StackTraceLine line = new StackTraceLine();
            lines.add(line);
            line.setFile("unknown");
            line.setLine(0);
            line.setFunction("unknown");
            return lines;
        }
        for (StackTraceElement element : exception.getStackTrace()) {
            StackTraceLine line = new StackTraceLine();
            line.setFile(element.getFileName());
            line.setLine(element.getLineNumber());
            line.setFunction(element.getClassName() + "." + element.getMethodName());
            lines.add(line);
        }
        return lines;
    }
}

