/**
 * Severr API
 * Get your application events and errors to Severr via the *Severr API*.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package io.severr.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.severr.model.CustomData;
import io.severr.model.Stacktrace;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * AppEvent
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2016-11-28T12:03:30.429-08:00")
public class AppEvent   {
  @SerializedName("apiKey")
  private String apiKey = null;

  @SerializedName("classification")
  private String classification = null;

  @SerializedName("eventType")
  private String eventType = null;

  @SerializedName("eventMessage")
  private String eventMessage = null;

  @SerializedName("eventTime")
  private Long eventTime = null;

  @SerializedName("eventStacktrace")
  private Stacktrace eventStacktrace = null;

  @SerializedName("eventUser")
  private String eventUser = null;

  @SerializedName("eventSession")
  private String eventSession = null;

  @SerializedName("contextAppVersion")
  private String contextAppVersion = null;

  @SerializedName("contextEnvName")
  private String contextEnvName = null;

  @SerializedName("contextEnvVersion")
  private String contextEnvVersion = null;

  @SerializedName("contextEnvHostname")
  private String contextEnvHostname = null;

  @SerializedName("contextAppBrowser")
  private String contextAppBrowser = null;

  @SerializedName("contextAppBrowserVersion")
  private String contextAppBrowserVersion = null;

  @SerializedName("contextAppOS")
  private String contextAppOS = null;

  @SerializedName("contextAppOSVersion")
  private String contextAppOSVersion = null;

  @SerializedName("contextDataCenter")
  private String contextDataCenter = null;

  @SerializedName("contextDataCenterRegion")
  private String contextDataCenterRegion = null;

  @SerializedName("customProperties")
  private CustomData customProperties = null;

  @SerializedName("customSegments")
  private CustomData customSegments = null;

  public AppEvent apiKey(String apiKey) {
    this.apiKey = apiKey;
    return this;
  }

   /**
   * API key generated for the application
   * @return apiKey
  **/
  @ApiModelProperty(example = "null", required = true, value = "API key generated for the application")
  public String getApiKey() {
    return apiKey;
  }

  public void setApiKey(String apiKey) {
    this.apiKey = apiKey;
  }

  public AppEvent classification(String classification) {
    this.classification = classification;
    return this;
  }

   /**
   * one of 'debug','info','warning','error' or a custom string
   * @return classification
  **/
  @ApiModelProperty(example = "null", required = true, value = "one of 'debug','info','warning','error' or a custom string")
  public String getClassification() {
    return classification;
  }

  public void setClassification(String classification) {
    this.classification = classification;
  }

  public AppEvent eventType(String eventType) {
    this.eventType = eventType;
    return this;
  }

   /**
   * type or event or error (eg. NullPointerException)
   * @return eventType
  **/
  @ApiModelProperty(example = "null", required = true, value = "type or event or error (eg. NullPointerException)")
  public String getEventType() {
    return eventType;
  }

  public void setEventType(String eventType) {
    this.eventType = eventType;
  }

  public AppEvent eventMessage(String eventMessage) {
    this.eventMessage = eventMessage;
    return this;
  }

   /**
   * message containing details of the event or error
   * @return eventMessage
  **/
  @ApiModelProperty(example = "null", required = true, value = "message containing details of the event or error")
  public String getEventMessage() {
    return eventMessage;
  }

  public void setEventMessage(String eventMessage) {
    this.eventMessage = eventMessage;
  }

  public AppEvent eventTime(Long eventTime) {
    this.eventTime = eventTime;
    return this;
  }

   /**
   * (optional) event time in ms since epoch
   * @return eventTime
  **/
  @ApiModelProperty(example = "null", value = "(optional) event time in ms since epoch")
  public Long getEventTime() {
    return eventTime;
  }

  public void setEventTime(Long eventTime) {
    this.eventTime = eventTime;
  }

  public AppEvent eventStacktrace(Stacktrace eventStacktrace) {
    this.eventStacktrace = eventStacktrace;
    return this;
  }

   /**
   * Get eventStacktrace
   * @return eventStacktrace
  **/
  @ApiModelProperty(example = "null", value = "")
  public Stacktrace getEventStacktrace() {
    return eventStacktrace;
  }

  public void setEventStacktrace(Stacktrace eventStacktrace) {
    this.eventStacktrace = eventStacktrace;
  }

  public AppEvent eventUser(String eventUser) {
    this.eventUser = eventUser;
    return this;
  }

   /**
   * (optional) event user identifying a user
   * @return eventUser
  **/
  @ApiModelProperty(example = "null", value = "(optional) event user identifying a user")
  public String getEventUser() {
    return eventUser;
  }

  public void setEventUser(String eventUser) {
    this.eventUser = eventUser;
  }

  public AppEvent eventSession(String eventSession) {
    this.eventSession = eventSession;
    return this;
  }

   /**
   * (optional) session identification
   * @return eventSession
  **/
  @ApiModelProperty(example = "null", value = "(optional) session identification")
  public String getEventSession() {
    return eventSession;
  }

  public void setEventSession(String eventSession) {
    this.eventSession = eventSession;
  }

  public AppEvent contextAppVersion(String contextAppVersion) {
    this.contextAppVersion = contextAppVersion;
    return this;
  }

   /**
   * (optional) application version information
   * @return contextAppVersion
  **/
  @ApiModelProperty(example = "null", value = "(optional) application version information")
  public String getContextAppVersion() {
    return contextAppVersion;
  }

  public void setContextAppVersion(String contextAppVersion) {
    this.contextAppVersion = contextAppVersion;
  }

  public AppEvent contextEnvName(String contextEnvName) {
    this.contextEnvName = contextEnvName;
    return this;
  }

   /**
   * (optional) one of 'development','staging','production' or a custom string
   * @return contextEnvName
  **/
  @ApiModelProperty(example = "null", value = "(optional) one of 'development','staging','production' or a custom string")
  public String getContextEnvName() {
    return contextEnvName;
  }

  public void setContextEnvName(String contextEnvName) {
    this.contextEnvName = contextEnvName;
  }

  public AppEvent contextEnvVersion(String contextEnvVersion) {
    this.contextEnvVersion = contextEnvVersion;
    return this;
  }

   /**
   * (optional) version of environment
   * @return contextEnvVersion
  **/
  @ApiModelProperty(example = "null", value = "(optional) version of environment")
  public String getContextEnvVersion() {
    return contextEnvVersion;
  }

  public void setContextEnvVersion(String contextEnvVersion) {
    this.contextEnvVersion = contextEnvVersion;
  }

  public AppEvent contextEnvHostname(String contextEnvHostname) {
    this.contextEnvHostname = contextEnvHostname;
    return this;
  }

   /**
   * (optional) hostname or ID of environment
   * @return contextEnvHostname
  **/
  @ApiModelProperty(example = "null", value = "(optional) hostname or ID of environment")
  public String getContextEnvHostname() {
    return contextEnvHostname;
  }

  public void setContextEnvHostname(String contextEnvHostname) {
    this.contextEnvHostname = contextEnvHostname;
  }

  public AppEvent contextAppBrowser(String contextAppBrowser) {
    this.contextAppBrowser = contextAppBrowser;
    return this;
  }

   /**
   * (optional) browser name if running in a browser (eg. Chrome)
   * @return contextAppBrowser
  **/
  @ApiModelProperty(example = "null", value = "(optional) browser name if running in a browser (eg. Chrome)")
  public String getContextAppBrowser() {
    return contextAppBrowser;
  }

  public void setContextAppBrowser(String contextAppBrowser) {
    this.contextAppBrowser = contextAppBrowser;
  }

  public AppEvent contextAppBrowserVersion(String contextAppBrowserVersion) {
    this.contextAppBrowserVersion = contextAppBrowserVersion;
    return this;
  }

   /**
   * (optional) browser version if running in a browser
   * @return contextAppBrowserVersion
  **/
  @ApiModelProperty(example = "null", value = "(optional) browser version if running in a browser")
  public String getContextAppBrowserVersion() {
    return contextAppBrowserVersion;
  }

  public void setContextAppBrowserVersion(String contextAppBrowserVersion) {
    this.contextAppBrowserVersion = contextAppBrowserVersion;
  }

  public AppEvent contextAppOS(String contextAppOS) {
    this.contextAppOS = contextAppOS;
    return this;
  }

   /**
   * (optional) OS the application is running on
   * @return contextAppOS
  **/
  @ApiModelProperty(example = "null", value = "(optional) OS the application is running on")
  public String getContextAppOS() {
    return contextAppOS;
  }

  public void setContextAppOS(String contextAppOS) {
    this.contextAppOS = contextAppOS;
  }

  public AppEvent contextAppOSVersion(String contextAppOSVersion) {
    this.contextAppOSVersion = contextAppOSVersion;
    return this;
  }

   /**
   * (optional) OS version the application is running on
   * @return contextAppOSVersion
  **/
  @ApiModelProperty(example = "null", value = "(optional) OS version the application is running on")
  public String getContextAppOSVersion() {
    return contextAppOSVersion;
  }

  public void setContextAppOSVersion(String contextAppOSVersion) {
    this.contextAppOSVersion = contextAppOSVersion;
  }

  public AppEvent contextDataCenter(String contextDataCenter) {
    this.contextDataCenter = contextDataCenter;
    return this;
  }

   /**
   * (optional) Data center the application is running on or connected to
   * @return contextDataCenter
  **/
  @ApiModelProperty(example = "null", value = "(optional) Data center the application is running on or connected to")
  public String getContextDataCenter() {
    return contextDataCenter;
  }

  public void setContextDataCenter(String contextDataCenter) {
    this.contextDataCenter = contextDataCenter;
  }

  public AppEvent contextDataCenterRegion(String contextDataCenterRegion) {
    this.contextDataCenterRegion = contextDataCenterRegion;
    return this;
  }

   /**
   * (optional) Data center region
   * @return contextDataCenterRegion
  **/
  @ApiModelProperty(example = "null", value = "(optional) Data center region")
  public String getContextDataCenterRegion() {
    return contextDataCenterRegion;
  }

  public void setContextDataCenterRegion(String contextDataCenterRegion) {
    this.contextDataCenterRegion = contextDataCenterRegion;
  }

  public AppEvent customProperties(CustomData customProperties) {
    this.customProperties = customProperties;
    return this;
  }

   /**
   * Get customProperties
   * @return customProperties
  **/
  @ApiModelProperty(example = "null", value = "")
  public CustomData getCustomProperties() {
    return customProperties;
  }

  public void setCustomProperties(CustomData customProperties) {
    this.customProperties = customProperties;
  }

  public AppEvent customSegments(CustomData customSegments) {
    this.customSegments = customSegments;
    return this;
  }

   /**
   * Get customSegments
   * @return customSegments
  **/
  @ApiModelProperty(example = "null", value = "")
  public CustomData getCustomSegments() {
    return customSegments;
  }

  public void setCustomSegments(CustomData customSegments) {
    this.customSegments = customSegments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppEvent appEvent = (AppEvent) o;
    return Objects.equals(this.apiKey, appEvent.apiKey) &&
        Objects.equals(this.classification, appEvent.classification) &&
        Objects.equals(this.eventType, appEvent.eventType) &&
        Objects.equals(this.eventMessage, appEvent.eventMessage) &&
        Objects.equals(this.eventTime, appEvent.eventTime) &&
        Objects.equals(this.eventStacktrace, appEvent.eventStacktrace) &&
        Objects.equals(this.eventUser, appEvent.eventUser) &&
        Objects.equals(this.eventSession, appEvent.eventSession) &&
        Objects.equals(this.contextAppVersion, appEvent.contextAppVersion) &&
        Objects.equals(this.contextEnvName, appEvent.contextEnvName) &&
        Objects.equals(this.contextEnvVersion, appEvent.contextEnvVersion) &&
        Objects.equals(this.contextEnvHostname, appEvent.contextEnvHostname) &&
        Objects.equals(this.contextAppBrowser, appEvent.contextAppBrowser) &&
        Objects.equals(this.contextAppBrowserVersion, appEvent.contextAppBrowserVersion) &&
        Objects.equals(this.contextAppOS, appEvent.contextAppOS) &&
        Objects.equals(this.contextAppOSVersion, appEvent.contextAppOSVersion) &&
        Objects.equals(this.contextDataCenter, appEvent.contextDataCenter) &&
        Objects.equals(this.contextDataCenterRegion, appEvent.contextDataCenterRegion) &&
        Objects.equals(this.customProperties, appEvent.customProperties) &&
        Objects.equals(this.customSegments, appEvent.customSegments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiKey, classification, eventType, eventMessage, eventTime, eventStacktrace, eventUser, eventSession, contextAppVersion, contextEnvName, contextEnvVersion, contextEnvHostname, contextAppBrowser, contextAppBrowserVersion, contextAppOS, contextAppOSVersion, contextDataCenter, contextDataCenterRegion, customProperties, customSegments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppEvent {\n");
    
    sb.append("    apiKey: ").append(toIndentedString(apiKey)).append("\n");
    sb.append("    classification: ").append(toIndentedString(classification)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    eventMessage: ").append(toIndentedString(eventMessage)).append("\n");
    sb.append("    eventTime: ").append(toIndentedString(eventTime)).append("\n");
    sb.append("    eventStacktrace: ").append(toIndentedString(eventStacktrace)).append("\n");
    sb.append("    eventUser: ").append(toIndentedString(eventUser)).append("\n");
    sb.append("    eventSession: ").append(toIndentedString(eventSession)).append("\n");
    sb.append("    contextAppVersion: ").append(toIndentedString(contextAppVersion)).append("\n");
    sb.append("    contextEnvName: ").append(toIndentedString(contextEnvName)).append("\n");
    sb.append("    contextEnvVersion: ").append(toIndentedString(contextEnvVersion)).append("\n");
    sb.append("    contextEnvHostname: ").append(toIndentedString(contextEnvHostname)).append("\n");
    sb.append("    contextAppBrowser: ").append(toIndentedString(contextAppBrowser)).append("\n");
    sb.append("    contextAppBrowserVersion: ").append(toIndentedString(contextAppBrowserVersion)).append("\n");
    sb.append("    contextAppOS: ").append(toIndentedString(contextAppOS)).append("\n");
    sb.append("    contextAppOSVersion: ").append(toIndentedString(contextAppOSVersion)).append("\n");
    sb.append("    contextDataCenter: ").append(toIndentedString(contextDataCenter)).append("\n");
    sb.append("    contextDataCenterRegion: ").append(toIndentedString(contextDataCenterRegion)).append("\n");
    sb.append("    customProperties: ").append(toIndentedString(customProperties)).append("\n");
    sb.append("    customSegments: ").append(toIndentedString(customSegments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

