/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import io.serialized.client.feed.SequenceNumberTracker;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;

public class InMemorySequenceNumberTracker
implements SequenceNumberTracker {
    private final AtomicLong sequenceNumber;

    public InMemorySequenceNumberTracker() {
        this.sequenceNumber = new AtomicLong(0L);
    }

    public InMemorySequenceNumberTracker(long initialValue) {
        this.sequenceNumber = new AtomicLong(initialValue);
    }

    @Override
    public long lastConsumedSequenceNumber() {
        return this.sequenceNumber.longValue();
    }

    @Override
    public void updateLastConsumedSequenceNumber(long sequenceNumber) {
        Validate.isTrue((sequenceNumber >= 0L ? 1 : 0) != 0, (String)"Illegal sequenceNumber [%d] - last consumed sequence number cannot be negative", (long)sequenceNumber);
        Validate.isTrue((sequenceNumber > this.sequenceNumber.get() ? 1 : 0) != 0, (String)"Illegal sequenceNumber [%d] - last consumed sequence number must be greater than current", (long)sequenceNumber);
        this.sequenceNumber.set(sequenceNumber);
    }

    @Override
    public void reset() {
        this.sequenceNumber.set(0L);
    }
}

