/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class Event<T> {
    private UUID eventId;
    private String eventType;
    private T data;
    private String encryptedData;

    public UUID eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public T data() {
        return this.data;
    }

    public String encryptedData() {
        return this.encryptedData;
    }

    public static RawBuilder newEvent(String eventType) {
        return new RawBuilder(eventType);
    }

    public static <T> TypedBuilder<T> newEvent(Class<T> eventType) {
        return new TypedBuilder<T>(eventType);
    }

    public static <T> TypedBuilder<T> newEvent(T data) {
        Class<?> aClass = data.getClass();
        return new TypedBuilder(aClass).data(data);
    }

    public static class RawBuilder {
        private UUID eventId;
        private final String eventType;
        private Object data = new LinkedHashMap();
        private String encryptedData;

        public RawBuilder(String eventType) {
            this.eventId = UUID.randomUUID();
            this.eventType = eventType;
        }

        public RawBuilder eventId(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public RawBuilder eventId(String eventId) {
            return this.eventId(UUID.fromString(eventId));
        }

        public RawBuilder data(Map<String, Object> data) {
            this.data = new LinkedHashMap<String, Object>(data);
            return this;
        }

        public RawBuilder data(String f1, Object d1) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(f1, d1);
            this.data = Collections.unmodifiableMap(map);
            return this;
        }

        public RawBuilder data(String f1, Object d1, String f2, Object d2) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(f1, d1);
            map.put(f2, d2);
            this.data = Collections.unmodifiableMap(map);
            return this;
        }

        public RawBuilder data(String f1, Object d1, String f2, Object d2, String f3, Object d3) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(f1, d1);
            map.put(f2, d2);
            map.put(f3, d3);
            this.data = Collections.unmodifiableMap(map);
            return this;
        }

        public RawBuilder data(String f1, Object d1, String f2, Object d2, String f3, Object d3, String f4, Object d4) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(f1, d1);
            map.put(f2, d2);
            map.put(f3, d3);
            map.put(f4, d4);
            this.data = Collections.unmodifiableMap(map);
            return this;
        }

        public RawBuilder data(String f1, Object d1, String f2, Object d2, String f3, Object d3, String f4, Object d4, String f5, Object d5) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(f1, d1);
            map.put(f2, d2);
            map.put(f3, d3);
            map.put(f4, d4);
            map.put(f5, d5);
            this.data = Collections.unmodifiableMap(map);
            return this;
        }

        public RawBuilder encryptedData(String data) {
            this.encryptedData = data;
            return this;
        }

        public Event build() {
            Event event = new Event();
            event.eventId = this.eventId;
            event.eventType = this.eventType;
            event.data = this.data;
            event.encryptedData = this.encryptedData;
            return event;
        }
    }

    public static class TypedBuilder<T> {
        private UUID eventId = UUID.randomUUID();
        private final String eventType;
        private T data;
        private String encryptedData;

        public TypedBuilder(String eventType) {
            this.eventType = eventType;
        }

        public TypedBuilder(Class<T> eventType) {
            this(eventType.getSimpleName());
        }

        public TypedBuilder<T> eventId(UUID eventId) {
            this.eventId = eventId;
            return this;
        }

        public TypedBuilder<T> data(T dataObject) {
            this.data = dataObject;
            return this;
        }

        public TypedBuilder<T> eventId(String eventId) {
            return this.eventId(UUID.fromString(eventId));
        }

        public TypedBuilder<T> encryptedData(String data) {
            this.encryptedData = data;
            return this;
        }

        public Event<T> build() {
            Event event = new Event();
            event.eventId = this.eventId;
            event.eventType = this.eventType;
            event.data = this.data;
            event.encryptedData = this.encryptedData;
            return event;
        }
    }
}

