/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import io.serialized.client.aggregate.AggregateRequest;
import io.serialized.client.aggregate.BulkSaveEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class AggregateBulkRequest {
    public final List<AggregateRequest> batches;
    private final UUID tenantId;

    private AggregateBulkRequest(Builder builder) {
        this.batches = Collections.unmodifiableList(builder.batches);
        this.tenantId = builder.tenantId;
    }

    public Optional<UUID> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public BulkSaveEvents eventBatches() {
        return BulkSaveEvents.newBulkSaveEvents(this.batches.stream().map(r -> r.eventBatch().withAggregateId(r.aggregateId)).collect(Collectors.toList()));
    }

    public static Builder bulkRequest() {
        return new Builder();
    }

    public static class Builder {
        private final List<AggregateRequest> batches = new ArrayList<AggregateRequest>();
        private UUID tenantId;

        public Builder withAggregateRequest(AggregateRequest request) {
            this.batches.add(request);
            return this;
        }

        public Builder withAggregateRequests(List<AggregateRequest> requests) {
            this.batches.addAll(requests);
            return this;
        }

        public Builder withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder withTenantId(String tenantId) {
            return this.withTenantId(UUID.fromString(tenantId));
        }

        public AggregateBulkRequest build() {
            if (this.batches.isEmpty()) {
                throw new IllegalStateException("batches is empty");
            }
            return new AggregateBulkRequest(this);
        }
    }
}

