/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import io.serialized.client.reaction.DeleteReactionRequest;
import io.serialized.client.reaction.ReactionRequest;
import io.serialized.client.reaction.TriggerReactionRequest;
import java.util.UUID;

public class ReactionRequests {
    public static ReactionRequest.Builder scheduled() {
        return new ReactionRequest.Builder(Type.SCHEDULED);
    }

    public static ReactionRequest.Builder triggered() {
        return new ReactionRequest.Builder(Type.TRIGGERED);
    }

    public static TriggerReactionRequest.Builder reTriggerReaction(UUID reactionId) {
        return new TriggerReactionRequest.Builder(Type.TRIGGERED).withReactionId(reactionId);
    }

    public static TriggerReactionRequest.Builder triggerReaction(UUID reactionId) {
        return new TriggerReactionRequest.Builder(Type.SCHEDULED).withReactionId(reactionId);
    }

    public static DeleteReactionRequest.Builder deleteReaction(UUID reactionId) {
        return new DeleteReactionRequest.Builder().withReactionId(reactionId);
    }

    public static enum Type {
        SCHEDULED("scheduled"),
        TRIGGERED("triggered");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

