/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public class GetFeedRequest {
    public final String feedName;
    public final Integer limit;
    public final Duration waitTime;
    public final boolean eagerFetching;
    public final UUID tenantId;
    public final Integer partitionCount;
    public final Integer partitionNumber;
    public final Set<String> types;

    private GetFeedRequest(Builder builder) {
        this.feedName = builder.feedName;
        this.limit = builder.limit;
        this.waitTime = builder.waitTime;
        this.eagerFetching = builder.eagerFetching;
        this.tenantId = builder.tenantId;
        this.partitionCount = builder.partitionCount;
        this.partitionNumber = builder.partitionNumber;
        this.types = Collections.unmodifiableSet(builder.types);
    }

    public Optional<UUID> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public static class Builder {
        private static final ValueRange WAIT_TIME_VALUE_RANGE = ValueRange.of(0L, 60L);
        private final Set<String> types = new LinkedHashSet<String>();
        private Integer limit;
        private String feedName = "_all";
        private Duration waitTime = Duration.ofSeconds(0L);
        private boolean eagerFetching = true;
        private UUID tenantId;
        private Integer partitionCount;
        private Integer partitionNumber;

        public Builder withTypes(String ... types) {
            this.types.addAll(Arrays.asList(types));
            return this;
        }

        public Builder withFeed(String feedName) {
            this.feedName = feedName;
            return this;
        }

        public Builder withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder withEagerFetching(boolean eagerFetching) {
            this.eagerFetching = eagerFetching;
            return this;
        }

        public Builder withWaitTime(Duration waitTime) {
            if (WAIT_TIME_VALUE_RANGE.isValidValue(waitTime.get(ChronoUnit.SECONDS))) {
                this.waitTime = waitTime;
                return this;
            }
            throw new IllegalArgumentException(String.format("waitTime must be within %d and %d seconds", WAIT_TIME_VALUE_RANGE.getMinimum(), WAIT_TIME_VALUE_RANGE.getMaximum()));
        }

        public Builder withPartitioning(int partitionCount, int partitionNumber) {
            Validate.isTrue((partitionCount > 1 ? 1 : 0) != 0, (String)"The total number of partitions must be greater than 1", (Object[])new Object[0]);
            Validate.isTrue((partitionNumber >= 0 ? 1 : 0) != 0, (String)"The partition number cannot be negative", (Object[])new Object[0]);
            Validate.isTrue((partitionNumber < partitionCount ? 1 : 0) != 0, (String)("The partition number is expected to be between 0 and (partitionCount - 1), in this case: " + (partitionCount - 1)), (Object[])new Object[0]);
            this.partitionCount = partitionCount;
            this.partitionNumber = partitionNumber;
            return this;
        }

        public GetFeedRequest build() {
            Validate.notNull((Object)this.feedName, (String)"'feedName' must be set", (Object[])new Object[0]);
            if (!this.feedName.equals("_all")) {
                Validate.isTrue((boolean)this.types.isEmpty(), (String)"type filter is only applicable when requesting the _all feed", (Object[])new Object[0]);
            }
            return new GetFeedRequest(this);
        }
    }
}

