/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client;

import java.net.URI;
import java.time.Duration;
import java.util.function.Consumer;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.Validate;

public class SerializedClientConfig {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String HTTPS_API_SERIALIZED_IO = "https://api.serialized.io/";
    private final OkHttpClient httpClient;
    private final HttpUrl apiRoot;

    private SerializedClientConfig(OkHttpClient httpClient, HttpUrl apiRoot) {
        this.httpClient = httpClient;
        this.apiRoot = apiRoot;
    }

    public static Builder serializedConfig() {
        return new Builder();
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public HttpUrl apiRoot() {
        return this.apiRoot;
    }

    public static class Builder {
        private final OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofSeconds(60L));
        private URI rootApiUrl = URI.create("https://api.serialized.io/");
        private String accessKey;
        private String secretAccessKey;

        public Builder rootApiUrl(String rootApiUrl) {
            this.rootApiUrl = URI.create(rootApiUrl);
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder configureHttpClient(Consumer<OkHttpClient.Builder> consumer) {
            consumer.accept(this.httpClientBuilder);
            return this;
        }

        public SerializedClientConfig build() {
            Validate.notNull((Object)this.rootApiUrl, (String)"'rootApiUrl' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.accessKey, (String)"'accessKey' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.secretAccessKey, (String)"'secretAccessKey' must be set", (Object[])new Object[0]);
            HttpUrl apiRoot = HttpUrl.get((URI)this.rootApiUrl);
            OkHttpClient client = this.httpClientBuilder.addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Serialized-Access-Key", this.accessKey).addHeader("Serialized-Secret-Access-Key", this.secretAccessKey).build())).build();
            return new SerializedClientConfig(client, apiRoot);
        }
    }
}

