/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Event {
    private String eventId;
    private String eventType;
    private Map<String, Object> data;
    private String encryptedData;

    public String eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public Map<String, Object> data() {
        return this.data == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.data);
    }

    public <T> T dataValueAs(String key, Class<T> clazz) {
        Object obj = this.data().get(key);
        if (obj == null) {
            throw new IllegalArgumentException("Key does not exist: " + key);
        }
        return clazz.cast(this.data.get(key));
    }

    public String encryptedData() {
        return this.encryptedData;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class Builder {
        private final String eventType;
        private String eventId;
        private Map<String, Object> data;
        private String encryptedData;

        public Builder(String eventType) {
            this.eventType = eventType;
        }

        public Builder withEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder withData(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public Builder withEncryptedData(String encryptedData) {
            this.encryptedData = encryptedData;
            return this;
        }

        public Event build() {
            Event event = new Event();
            event.eventType = this.eventType;
            event.eventId = this.eventId;
            event.data = this.data;
            event.encryptedData = this.encryptedData;
            return event;
        }
    }
}

