/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public interface UpdateStrategy {
    public static final UpdateStrategy DEFAULT = new Builder().withFailOnMissingHandler(true).build();

    public boolean failOnMissingHandler();

    public Set<String> ignoredEventTypes();

    public static class Builder {
        private boolean failOnMissingHandler = true;
        private final Set<String> ignoredEventTypes = new LinkedHashSet<String>();

        public Builder withFailOnMissingHandler(boolean failOnMissingHandler) {
            this.failOnMissingHandler = failOnMissingHandler;
            return this;
        }

        public Builder withIgnoredEventTypes(String ... eventTypes) {
            this.ignoredEventTypes.addAll(Arrays.asList(eventTypes));
            return this;
        }

        public UpdateStrategy build() {
            return new UpdateStrategy(){

                @Override
                public boolean failOnMissingHandler() {
                    return failOnMissingHandler;
                }

                @Override
                public Set<String> ignoredEventTypes() {
                    return ignoredEventTypes;
                }
            };
        }
    }
}

