/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.reaction.DeleteReactionRequest;
import io.serialized.client.reaction.ReactionDefinition;
import io.serialized.client.reaction.ReactionDefinitions;
import io.serialized.client.reaction.ReactionRequest;
import io.serialized.client.reaction.ReactionsResponse;
import io.serialized.client.reaction.TriggerReactionRequest;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ReactionClient {
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final ObjectMapper objectMapper;

    private ReactionClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
        this.objectMapper = builder.objectMapper;
    }

    public static Builder reactionClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    public void createDefinition(ReactionDefinition reactionDefinition) {
        HttpUrl url = this.pathForDefinitions().build();
        this.client.post(url, reactionDefinition);
    }

    public void createDefinition(String jsonString) throws IOException {
        ReactionDefinition reactionDefinition = (ReactionDefinition)this.objectMapper.readValue(jsonString, ReactionDefinition.class);
        this.createDefinition(reactionDefinition);
    }

    public void createOrUpdate(ReactionDefinition reactionDefinition) {
        String reactionName = reactionDefinition.reactionName();
        HttpUrl url = this.pathForDefinitions().addPathSegment(reactionName).build();
        this.client.put(url, reactionDefinition);
    }

    public void createOrUpdate(String jsonString) throws IOException {
        ReactionDefinition reactionDefinition = (ReactionDefinition)this.objectMapper.readValue(jsonString, ReactionDefinition.class);
        this.createOrUpdate(reactionDefinition);
    }

    public ReactionDefinition getDefinition(String reactionName) {
        HttpUrl url = this.pathForDefinitions().addPathSegment(reactionName).build();
        return this.client.get(url, ReactionDefinition.class);
    }

    public ReactionDefinitions listDefinitions() {
        HttpUrl url = this.pathForDefinitions().build();
        return this.client.get(url, ReactionDefinitions.class);
    }

    public void deleteDefinition(String reactionName) {
        HttpUrl url = this.pathForDefinitions().addPathSegment(reactionName).build();
        this.client.delete(url);
    }

    public ReactionsResponse listReactions(ReactionRequest request) {
        HttpUrl url = this.pathForReactions(request.type).build();
        if (request.hasTenantId()) {
            return this.client.get(url, ReactionsResponse.class, request.tenantId);
        }
        return this.client.get(url, ReactionsResponse.class);
    }

    public void triggerReaction(TriggerReactionRequest request) {
        HttpUrl url = this.pathForReaction(request.type, request.reactionId).build();
        if (request.hasTenantId()) {
            this.client.post(url, "", request.tenantId);
        } else {
            this.client.post(url, "");
        }
    }

    public void deleteReaction(DeleteReactionRequest request) {
        HttpUrl url = this.pathForReaction(request.type, request.reactionId).build();
        if (request.hasTenantId()) {
            this.client.delete(url, request.tenantId);
        } else {
            this.client.delete(url);
        }
    }

    private HttpUrl.Builder pathForDefinitions() {
        return this.apiRoot.newBuilder().addPathSegment("reactions").addPathSegment("definitions");
    }

    private HttpUrl.Builder pathForReactions(String type) {
        return this.apiRoot.newBuilder().addPathSegment("reactions").addPathSegment(type);
    }

    private HttpUrl.Builder pathForReaction(String type, UUID reactionId) {
        return this.apiRoot.newBuilder().addPathSegment("reactions").addPathSegment(type).addPathSegment(reactionId.toString());
    }

    public static class Builder {
        private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        private final OkHttpClient httpClient;
        private final HttpUrl apiRoot;

        public Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.apiRoot = config.apiRoot();
        }

        public Builder configureObjectMapper(Consumer<ObjectMapper> consumer) {
            consumer.accept(this.objectMapper);
            return this;
        }

        public ReactionClient build() {
            return new ReactionClient(this);
        }
    }
}

