/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.util.UUID;

public class GetFeedRequest {
    public final String feedName;
    public final Integer limit;
    public final Duration pollDelay;
    public final boolean eagerFetching;
    public final UUID tenantId;

    private GetFeedRequest(Builder builder) {
        this.feedName = builder.feedName;
        this.limit = builder.limit;
        this.pollDelay = builder.pollDelay;
        this.eagerFetching = builder.eagerFetching;
        this.tenantId = builder.tenantId;
    }

    public boolean hasTenantId() {
        return this.tenantId != null;
    }

    public static class Builder {
        private static final ValueRange SUBSCRIPTION_POLL_DELAY_VALUE_RANGE = ValueRange.of(1L, 60L);
        private Integer limit;
        private String feedName;
        private Duration pollDelay = Duration.ofSeconds(1L);
        private boolean eagerFetching = true;
        private UUID tenantId;

        public Builder withFeed(String feedName) {
            this.feedName = feedName;
            return this;
        }

        public Builder withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder withEagerFetching(boolean eagerFetching) {
            this.eagerFetching = eagerFetching;
            return this;
        }

        public Builder withSubscriptionPollDelay(Duration pollDelay) {
            if (SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.isValidValue(pollDelay.get(ChronoUnit.SECONDS))) {
                this.pollDelay = pollDelay;
                return this;
            }
            throw new IllegalArgumentException(String.format("Poll delay must be within %d and %d seconds", SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.getMinimum(), SUBSCRIPTION_POLL_DELAY_VALUE_RANGE.getMaximum()));
        }

        public GetFeedRequest build() {
            return new GetFeedRequest(this);
        }
    }
}

