/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.feed.Feed;
import io.serialized.client.feed.FeedEntry;
import io.serialized.client.feed.FeedEntryHandler;
import io.serialized.client.feed.FeedResponse;
import io.serialized.client.feed.FeedsResponse;
import io.serialized.client.feed.GetFeedRequest;
import io.serialized.client.feed.GetSequenceNumberRequest;
import io.serialized.client.feed.ListFeedsRequest;
import io.serialized.client.feed.RetryException;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.apache.commons.lang3.Validate;

public class FeedClient
implements Closeable {
    private static final String SEQUENCE_NUMBER_HEADER = "Serialized-SequenceNumber-Current";
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final Set<ExecutorService> executors = new HashSet<ExecutorService>();

    private FeedClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
    }

    public static Builder feedClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    @Override
    public void close() {
        this.executors.forEach(ExecutorService::shutdown);
    }

    public FeedResponse execute(GetFeedRequest request, long since) {
        HttpUrl.Builder urlBuilder = this.url(request.feedName);
        Optional.ofNullable(request.limit).ifPresent(limit -> urlBuilder.addQueryParameter("limit", String.valueOf(limit)));
        HttpUrl url = urlBuilder.addQueryParameter("since", String.valueOf(since)).build();
        if (request.hasTenantId()) {
            return this.client.get(url, FeedResponse.class, request.tenantId);
        }
        return this.client.get(url, FeedResponse.class);
    }

    public void execute(GetFeedRequest request, long since, FeedEntryHandler feedEntryHandler) {
        FeedResponse response;
        long offset = since;
        do {
            response = this.execute(request, offset);
            for (FeedEntry feedEntry : response.entries()) {
                feedEntryHandler.handle(feedEntry);
                offset = feedEntry.sequenceNumber();
            }
        } while (request.eagerFetching && response.hasMore());
    }

    public void subscribe(GetFeedRequest request, FeedEntryHandler feedEntryHandler) {
        this.subscribe(request, 0L, feedEntryHandler);
    }

    public void subscribe(GetFeedRequest request, long since, FeedEntryHandler feedEntryHandler) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        AtomicLong offset = new AtomicLong(since);
        executor.scheduleWithFixedDelay(() -> {
            FeedResponse response;
            do {
                response = this.execute(request, offset.get());
                for (FeedEntry feedEntry : response.entries()) {
                    try {
                        feedEntryHandler.handle(feedEntry);
                        offset.set(feedEntry.sequenceNumber());
                    }
                    catch (RetryException retryException) {}
                }
            } while (request.eagerFetching && response.hasMore());
        }, request.pollDelay.getSeconds(), request.pollDelay.getSeconds(), TimeUnit.SECONDS);
        this.executors.add(executor);
    }

    public List<Feed> execute(ListFeedsRequest request) {
        HttpUrl url = this.apiRoot.newBuilder().addPathSegment("feeds").build();
        if (request.hasTenantId()) {
            return this.client.get(url, FeedsResponse.class, request.tenantId).feeds();
        }
        return this.client.get(url, FeedsResponse.class).feeds();
    }

    public long execute(GetSequenceNumberRequest request) {
        HttpUrl url = this.url(request.feedName).build();
        Function<Response, Long> func = response -> Long.parseLong(Objects.requireNonNull(response.header(SEQUENCE_NUMBER_HEADER)));
        if (request.hasTenantId()) {
            return this.client.head(url, func, request.tenantId);
        }
        return this.client.head(url, func);
    }

    private HttpUrl.Builder url(String feedName) {
        Validate.notBlank((CharSequence)feedName, (String)"No feed specified", (Object[])new Object[0]);
        return this.apiRoot.newBuilder().addPathSegment("feeds").addPathSegment(feedName);
    }

    public static class Builder {
        private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        private final OkHttpClient httpClient;
        private final HttpUrl apiRoot;

        public Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.apiRoot = config.apiRoot();
        }

        public Builder configureObjectMapper(Consumer<ObjectMapper> consumer) {
            consumer.accept(this.objectMapper);
            return this;
        }

        public FeedClient build() {
            return new FeedClient(this);
        }
    }
}

