/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.feed;

import io.serialized.client.feed.Event;
import io.serialized.client.feed.FeedEntry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FeedResponse {
    private List<FeedEntry> entries;
    private long currentSequenceNumber;
    private boolean hasMore;

    public FeedResponse() {
    }

    public FeedResponse(List<FeedEntry> entries) {
        this.entries = entries;
    }

    public FeedResponse(List<FeedEntry> entries, long currentSequenceNumber, boolean hasMore) {
        this.entries = entries;
        this.currentSequenceNumber = currentSequenceNumber;
        this.hasMore = hasMore;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.entries().stream().flatMap(e -> e.events().stream()).collect(Collectors.toList()));
    }

    public List<FeedEntry> entries() {
        return this.entries == null ? Collections.emptyList() : Collections.unmodifiableList(this.entries);
    }

    public long currentSequenceNumber() {
        return this.currentSequenceNumber;
    }

    public boolean hasMore() {
        return this.hasMore;
    }
}

