/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.projection;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.projection.ProjectionDefinition;
import io.serialized.client.projection.ProjectionDefinitions;
import io.serialized.client.projection.ProjectionRequest;
import io.serialized.client.projection.ProjectionResponse;
import io.serialized.client.projection.ProjectionType;
import io.serialized.client.projection.ProjectionsResponse;
import io.serialized.client.projection.query.ListProjectionQuery;
import io.serialized.client.projection.query.ProjectionQuery;
import java.io.IOException;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ProjectionClient {
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final ObjectMapper objectMapper;

    private ProjectionClient(Builder builder) {
        this.client = new SerializedOkHttpClient(builder.httpClient, builder.objectMapper);
        this.apiRoot = builder.apiRoot;
        this.objectMapper = builder.objectMapper;
    }

    public static Builder projectionClient(SerializedClientConfig config) {
        return new Builder(config);
    }

    public void createDefinition(ProjectionDefinition projectionDefinition) {
        HttpUrl url = this.pathForDefinitions().build();
        this.client.post(url, projectionDefinition);
    }

    public void createDefinition(String jsonString) throws IOException {
        ProjectionDefinition projectionDefinition = (ProjectionDefinition)this.objectMapper.readValue(jsonString, ProjectionDefinition.class);
        this.createDefinition(projectionDefinition);
    }

    public void createOrUpdate(ProjectionDefinition projectionDefinition) {
        String projectionName = projectionDefinition.projectionName();
        HttpUrl url = this.pathForDefinitions().addPathSegment(projectionName).build();
        this.client.put(url, projectionDefinition);
    }

    public void createOrUpdate(String jsonString) throws IOException {
        ProjectionDefinition projectionDefinition = (ProjectionDefinition)this.objectMapper.readValue(jsonString, ProjectionDefinition.class);
        this.createOrUpdate(projectionDefinition);
    }

    public ProjectionDefinition getDefinition(String projectionName) {
        HttpUrl url = this.pathForDefinitions().addPathSegment(projectionName).build();
        return this.client.get(url, ProjectionDefinition.class);
    }

    public ProjectionDefinitions listDefinitions() {
        HttpUrl url = this.pathForDefinitions().build();
        return this.client.get(url, ProjectionDefinitions.class);
    }

    public void deleteDefinition(String projectionName) {
        HttpUrl url = this.pathForDefinitions().addPathSegment(projectionName).build();
        this.client.delete(url);
    }

    public void delete(ProjectionRequest request) {
        HttpUrl url = this.pathForProjections(request.projectionName, request.projectionType).build();
        if (request.hasTenantId()) {
            this.client.delete(url, request.tenantId);
        } else {
            this.client.delete(url);
        }
    }

    private HttpUrl.Builder pathForDefinitions() {
        return this.apiRoot.newBuilder().addPathSegment("projections").addPathSegment("definitions");
    }

    private HttpUrl.Builder pathForProjections(String projectionName, ProjectionType type) {
        return this.apiRoot.newBuilder().addPathSegment("projections").addPathSegment(type.name().toLowerCase()).addPathSegment(projectionName);
    }

    public <T> ProjectionResponse<T> query(ProjectionQuery query) {
        HttpUrl url = query.constructUrl(this.apiRoot);
        JavaType javaType = query.responseClass().map(dataClass -> this.objectMapper.getTypeFactory().constructParametricType(ProjectionResponse.class, new Class[]{dataClass})).orElse(this.objectMapper.getTypeFactory().constructParametricType(ProjectionResponse.class, new Class[]{Map.class}));
        if (query.tenantId().isPresent()) {
            return (ProjectionResponse)this.client.get(url, javaType, query.tenantId().get());
        }
        return (ProjectionResponse)this.client.get(url, javaType);
    }

    public <T> ProjectionsResponse<T> query(ListProjectionQuery query) {
        HttpUrl url = query.constructUrl(this.apiRoot);
        JavaType javaType = query.responseClass().map(dataClass -> this.objectMapper.getTypeFactory().constructParametricType(ProjectionsResponse.class, new Class[]{dataClass})).orElse(this.objectMapper.getTypeFactory().constructParametricType(ProjectionResponse.class, new Class[]{Map.class}));
        if (query.tenantId().isPresent()) {
            return (ProjectionsResponse)this.client.get(url, javaType, query.tenantId().get());
        }
        return (ProjectionsResponse)this.client.get(url, javaType);
    }

    public static class Builder {
        private final OkHttpClient httpClient;
        private final ObjectMapper objectMapper;
        private final HttpUrl apiRoot;

        public Builder(SerializedClientConfig config) {
            this.httpClient = config.httpClient();
            this.objectMapper = config.objectMapper();
            this.apiRoot = config.apiRoot();
        }

        public ProjectionClient build() {
            return new ProjectionClient(this);
        }
    }
}

