/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.reaction;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ReactionDefinition {
    private String reactionName;
    private String feedName;
    private String reactOnEventType;
    private String triggerTimeField;
    private String offset;
    private Set<String> cancelOnEventTypes;
    private Action action;

    public String reactionName() {
        return this.reactionName;
    }

    public String feedName() {
        return this.feedName;
    }

    public String reactOnEventType() {
        return this.reactOnEventType;
    }

    public String triggerTimeField() {
        return this.triggerTimeField;
    }

    public String offset() {
        return this.offset;
    }

    public Set<String> cancelOnEventTypes() {
        return this.cancelOnEventTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.cancelOnEventTypes);
    }

    public Action action() {
        return this.action;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static DefinitionBuilder newReactionDefinition(String reactionName) {
        return new DefinitionBuilder(reactionName);
    }

    public static class Action {
        private String actionType;
        private Map<String, Object> httpHeaders;
        private URI targetUri;
        private String body;
        private Map<String, String> valueMap;

        public String actionType() {
            return this.actionType;
        }

        public Map<String, Object> httpHeaders() {
            return this.httpHeaders;
        }

        public URI targetUri() {
            return this.targetUri;
        }

        public String body() {
            return this.body;
        }

        public Map<String, String> valueMap() {
            return this.valueMap;
        }

        static Action newAction(String actionType, URI targetUri, Map<String, Object> httpHeaders, String body, Map<String, String> valueMap) {
            Action action = new Action();
            action.actionType = actionType;
            action.targetUri = targetUri;
            action.httpHeaders = httpHeaders;
            action.body = body;
            action.valueMap = valueMap;
            return action;
        }
    }

    public static class DefinitionBuilder {
        private final String reactionName;
        private final Set<String> cancelOnEventTypes = new LinkedHashSet<String>();
        private String feedName;
        private String reactOnEventType;
        private String triggerTimeField;
        private String offset;
        private Action action;

        DefinitionBuilder(String reactionName) {
            this.reactionName = reactionName;
        }

        public DefinitionBuilder feed(String feedName) {
            this.feedName = feedName;
            return this;
        }

        public DefinitionBuilder reactOnEventType(String reactOnEventType) {
            this.reactOnEventType = reactOnEventType;
            return this;
        }

        public DefinitionBuilder triggerTimeField(String triggerTimeField) {
            this.triggerTimeField = triggerTimeField;
            return this;
        }

        public DefinitionBuilder offset(String offset) {
            this.offset = offset;
            return this;
        }

        public DefinitionBuilder cancelOnEventType(String ... eventTypes) {
            this.cancelOnEventTypes.addAll(Arrays.asList(eventTypes));
            return this;
        }

        public DefinitionBuilder action(Action action) {
            this.action = action;
            return this;
        }

        public ReactionDefinition build() {
            ReactionDefinition definition = new ReactionDefinition();
            definition.reactionName = this.reactionName;
            definition.feedName = this.feedName;
            definition.reactOnEventType = this.reactOnEventType;
            definition.triggerTimeField = this.triggerTimeField;
            definition.offset = this.offset;
            definition.cancelOnEventTypes = this.cancelOnEventTypes;
            definition.action = this.action;
            return definition;
        }
    }
}

