/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.projection.query;

import io.serialized.client.projection.ProjectionType;
import io.serialized.client.projection.query.ProjectionQuery;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.Validate;

public class SingleProjectionQuery
implements ProjectionQuery {
    private final Class responseClass;
    private final Function<HttpUrl, HttpUrl> urlBuilder;
    private final UUID tenantId;

    private SingleProjectionQuery(Function<HttpUrl, HttpUrl> urlBuilder, Class responseClass, UUID tenantId) {
        this.urlBuilder = urlBuilder;
        this.responseClass = responseClass;
        this.tenantId = tenantId;
    }

    @Override
    public HttpUrl constructUrl(HttpUrl rootUrl) {
        return this.urlBuilder.apply(rootUrl);
    }

    @Override
    public Optional<UUID> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    @Override
    public Optional<Class> responseClass() {
        return Optional.ofNullable(this.responseClass);
    }

    public static class Builder {
        private final String projectionName;
        private String projectionId;
        private Duration duration;
        private UUID tenantId;

        public Builder(String projectionName) {
            this.projectionName = projectionName;
        }

        public Builder id(String projectionId) {
            this.projectionId = projectionId;
            return this;
        }

        public Builder id(UUID projectionId) {
            this.projectionId = projectionId.toString();
            return this;
        }

        public Builder awaitCreation(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder withTenantId(UUID tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        private HttpUrl urlBuilder(HttpUrl rootUrl) {
            HttpUrl.Builder builder = rootUrl.newBuilder().addPathSegment("projections").addPathSegment(ProjectionType.SINGLE.name().toLowerCase()).addPathSegment(this.projectionName).addPathSegment(this.projectionId);
            if (this.duration != null) {
                Validate.isTrue((this.duration.toMillis() > 0L ? 1 : 0) != 0, (String)"Duration must be positive", (Object[])new Object[0]);
                Validate.isTrue((this.duration.toMillis() < Duration.of(60L, ChronoUnit.SECONDS).toMillis() ? 1 : 0) != 0, (String)"Duration can be maximum 60s", (Object[])new Object[0]);
                builder.addQueryParameter("awaitCreation", String.valueOf(this.duration.toMillis()));
            }
            return builder.build();
        }

        public SingleProjectionQuery build(Class responseClass) {
            Validate.notEmpty((CharSequence)this.projectionName, (String)"'projectionName' must be set", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)this.projectionId, (String)"'projectionId' must be set", (Object[])new Object[0]);
            return new SingleProjectionQuery(this::urlBuilder, responseClass, this.tenantId);
        }
    }
}

