/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.serialized.client.ApiException;
import io.serialized.client.ConcurrencyException;
import io.serialized.client.SerializedClientConfig;
import io.serialized.client.SerializedOkHttpClient;
import io.serialized.client.aggregate.AggregateDelete;
import io.serialized.client.aggregate.AggregateRequest;
import io.serialized.client.aggregate.AggregateUpdate;
import io.serialized.client.aggregate.Event;
import io.serialized.client.aggregate.EventBatch;
import io.serialized.client.aggregate.EventDeserializer;
import io.serialized.client.aggregate.EventHandler;
import io.serialized.client.aggregate.StateBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.apache.commons.lang3.Validate;

public class AggregateClient<T> {
    private final SerializedOkHttpClient client;
    private final HttpUrl apiRoot;
    private final StateBuilder<T> stateBuilder;
    private final String aggregateType;
    private final boolean useOptimisticConcurrencyOnUpdate;

    private AggregateClient(Builder<T> builder) {
        this.client = new SerializedOkHttpClient(((Builder)builder).httpClient, ((Builder)builder).objectMapper);
        this.apiRoot = ((Builder)builder).apiRoot;
        this.aggregateType = ((Builder)builder).aggregateType;
        this.stateBuilder = ((Builder)builder).stateBuilder;
        this.useOptimisticConcurrencyOnUpdate = ((Builder)builder).useOptimisticConcurrencyOnUpdate;
    }

    public static <T> Builder<T> aggregateClient(String aggregateType, Class<T> stateClass, SerializedClientConfig config) {
        return new Builder<T>(aggregateType, stateClass, config);
    }

    public void save(AggregateRequest request) {
        try {
            HttpUrl url = this.getAggregateUrl(request.aggregateId).addPathSegment("events").build();
            if (request.tenantId().isPresent()) {
                UUID tenantId = request.tenantId().get();
                this.client.post(url, request.eventBatch(), tenantId);
            } else {
                this.client.post(url, request.eventBatch());
            }
        }
        catch (ApiException e) {
            this.handleConcurrencyException(e);
        }
    }

    public void update(String aggregateId, AggregateUpdate<T> update) {
        this.update(UUID.fromString(aggregateId), update);
    }

    public void update(UUID aggregateId, AggregateUpdate<T> update) {
        LoadAggregateResponse aggregateResponse = this.loadState(aggregateId);
        T state = this.stateBuilder.buildState(aggregateResponse.events);
        Long expectedVersion = this.getExpectedVersion(aggregateResponse);
        List<Event<?>> events = update.apply(state);
        this.storeBatch(aggregateId, new EventBatch(events, expectedVersion));
    }

    public void update(UUID aggregateId, UUID tenantId, AggregateUpdate<T> update) {
        LoadAggregateResponse aggregateResponse = this.loadState(aggregateId, tenantId);
        T state = this.stateBuilder.buildState(aggregateResponse.events);
        Long expectedVersion = this.getExpectedVersion(aggregateResponse);
        List<Event<?>> events = update.apply(state);
        this.storeBatch(aggregateId, tenantId, new EventBatch(events, expectedVersion));
    }

    public AggregateDelete<T> deleteByType() {
        return this.getDeleteToken(this.getAggregateTypeUrl());
    }

    public AggregateDelete<T> deleteByType(UUID tenantId) {
        return this.getDeleteToken(this.getAggregateTypeUrl(), tenantId);
    }

    public AggregateDelete<T> deleteById(UUID aggregateId) {
        return this.getDeleteToken(this.getAggregateUrl(aggregateId));
    }

    public AggregateDelete<T> deleteById(UUID aggregateId, UUID tenantId) {
        return this.getDeleteToken(this.getAggregateUrl(aggregateId), tenantId);
    }

    public boolean exists(UUID aggregateId) {
        try {
            HttpUrl url = this.getAggregateUrl(aggregateId).build();
            return this.client.head(url, Response::code) == 200;
        }
        catch (ApiException e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public boolean exists(UUID aggregateId, UUID tenantId) {
        try {
            HttpUrl url = this.getAggregateUrl(aggregateId).build();
            return this.client.head(url, Response::code, tenantId) == 200;
        }
        catch (ApiException e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private Long getExpectedVersion(LoadAggregateResponse aggregateResponse) {
        return this.useOptimisticConcurrencyOnUpdate ? Long.valueOf(aggregateResponse.aggregateVersion) : null;
    }

    private AggregateDelete<T> getDeleteToken(HttpUrl.Builder urlBuilder) {
        return this.extractDeleteToken(urlBuilder, this.client.delete(urlBuilder.build(), Map.class));
    }

    private AggregateDelete<T> getDeleteToken(HttpUrl.Builder urlBuilder, UUID tenantId) {
        return this.extractDeleteToken(urlBuilder, this.client.delete(urlBuilder.build(), Map.class, tenantId));
    }

    private AggregateDelete<T> extractDeleteToken(HttpUrl.Builder urlBuilder, Map<String, String> deleteResponse) {
        String deleteToken = deleteResponse.get("deleteToken");
        HttpUrl deleteAggregateUrl = urlBuilder.addQueryParameter("deleteToken", deleteToken).build();
        return new AggregateDelete(this.client, deleteAggregateUrl);
    }

    private LoadAggregateResponse loadState(UUID aggregateId) {
        HttpUrl url = this.getAggregateUrl(aggregateId).build();
        return this.client.get(url, LoadAggregateResponse.class);
    }

    private LoadAggregateResponse loadState(UUID aggregateId, UUID tenantId) {
        HttpUrl url = this.getAggregateUrl(aggregateId).build();
        return this.client.get(url, LoadAggregateResponse.class, tenantId);
    }

    private void storeBatch(UUID aggregateId, EventBatch eventBatch) {
        if (eventBatch.events().isEmpty()) {
            return;
        }
        try {
            HttpUrl url = this.getAggregateUrl(aggregateId).addPathSegment("events").build();
            this.client.post(url, eventBatch);
        }
        catch (ApiException e) {
            this.handleConcurrencyException(e);
        }
    }

    private void storeBatch(UUID aggregateId, UUID tenantId, EventBatch eventBatch) {
        if (eventBatch.events().isEmpty()) {
            return;
        }
        try {
            HttpUrl url = this.getAggregateUrl(aggregateId).addPathSegment("events").build();
            this.client.post(url, eventBatch, tenantId);
        }
        catch (ApiException e) {
            this.handleConcurrencyException(e);
        }
    }

    private void handleConcurrencyException(ApiException e) {
        if (e.statusCode() == 409) {
            throw new ConcurrencyException(409, e.getMessage());
        }
        throw e;
    }

    private HttpUrl.Builder getAggregateTypeUrl() {
        return this.apiRoot.newBuilder().addPathSegment("aggregates").addPathSegment(this.aggregateType);
    }

    private HttpUrl.Builder getAggregateUrl(UUID aggregateId) {
        return this.getAggregateTypeUrl().addPathSegment(aggregateId.toString());
    }

    private static class LoadAggregateResponse {
        String aggregateId;
        String aggregateType;
        long aggregateVersion;
        List<Event<?>> events;

        private LoadAggregateResponse() {
        }
    }

    public static class Builder<T> {
        private final HttpUrl apiRoot;
        private final OkHttpClient httpClient;
        private final ObjectMapper objectMapper;
        private final StateBuilder<T> stateBuilder;
        private final String aggregateType;
        private final Map<String, Class> eventTypes = new HashMap<String, Class>();
        private boolean useOptimisticConcurrencyOnUpdate = true;

        Builder(String aggregateType, Class<T> stateClass, SerializedClientConfig config) {
            this.aggregateType = aggregateType;
            this.apiRoot = config.apiRoot();
            this.httpClient = config.httpClient();
            this.objectMapper = config.objectMapper();
            this.stateBuilder = StateBuilder.stateBuilder(stateClass);
        }

        public <E> Builder<T> registerHandler(Class<E> eventClass, EventHandler<T, E> handler) {
            return this.registerHandler(eventClass.getSimpleName(), eventClass, handler);
        }

        public <E> Builder<T> registerHandler(String eventType, Class<E> eventClass, EventHandler<T, E> handler) {
            this.eventTypes.put(eventType, eventClass);
            this.stateBuilder.withHandler(eventClass, handler);
            return this;
        }

        public Builder<T> useOptimisticConcurrencyOnUpdate(boolean useOptimisticConcurrencyOnUpdate) {
            this.useOptimisticConcurrencyOnUpdate = useOptimisticConcurrencyOnUpdate;
            return this;
        }

        public AggregateClient<T> build() {
            Validate.notNull((Object)this.aggregateType, (String)"'aggregateType' must be set", (Object[])new Object[0]);
            this.objectMapper.registerModule(EventDeserializer.module(this.eventTypes));
            return new AggregateClient(this);
        }
    }
}

