/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.aggregate;

import io.serialized.client.aggregate.Command;
import io.serialized.client.aggregate.Event;
import io.serialized.client.aggregate.StateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AggregateFactory<A, T> {
    private final StateBuilder<T> stateBuilder;
    private final Function<T, A> initializer;

    public AggregateFactory(Function<T, A> initializer, StateBuilder<T> stateBuilder) {
        this.stateBuilder = stateBuilder;
        this.initializer = initializer;
    }

    public A fromCommands(List<Command<A>> commands) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Command<A> command : commands) {
            T aggregateState = this.stateBuilder.buildState(events);
            A a = this.initializer.apply(aggregateState);
            List<Event> apply = command.apply(a);
            events.addAll(apply);
        }
        T lastState = this.stateBuilder.buildState(events);
        return this.initializer.apply(lastState);
    }

    @SafeVarargs
    public final A fromCommands(Command<A> ... commands) {
        return this.fromCommands(Arrays.asList(commands));
    }

    public static <A, T> AggregateFactory<A, T> newFactory(Function<T, A> initializer, StateBuilder<T> stateBuilder) {
        return new AggregateFactory<A, T>(initializer, stateBuilder);
    }
}

