/*
 * Decompiled with CFR 0.152.
 */
package io.serialized.client.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import io.serialized.client.feed.SequenceNumberTracker;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class DynamoDbSequenceNumberTracker
implements SequenceNumberTracker {
    private final AmazonDynamoDB dynamoDB;
    private final String tableName;
    private final String trackerName;
    private final DynamoDBMapper dynamoDBMapper;

    public DynamoDbSequenceNumberTracker(AmazonDynamoDB dynamoDB, String tableName, String trackerName) {
        this.dynamoDB = dynamoDB;
        this.dynamoDBMapper = new DynamoDBMapper(dynamoDB, DynamoDBMapperConfig.builder().withConsistentReads(DynamoDBMapperConfig.ConsistentReads.CONSISTENT).withTableNameResolver((clazz, config) -> tableName).build());
        this.tableName = tableName;
        this.trackerName = trackerName;
        this.init();
    }

    protected void init() {
        try {
            TableUtils.createTableIfNotExists((AmazonDynamoDB)this.dynamoDB, (CreateTableRequest)this.generateCreateTableRequest());
            TableUtils.waitUntilExists((AmazonDynamoDB)this.dynamoDB, (String)this.tableName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected CreateTableRequest generateCreateTableRequest() {
        return this.dynamoDBMapper.generateCreateTableRequest(Tracker.class).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)));
    }

    public long lastConsumedSequenceNumber() {
        Validate.isTrue((this.dynamoDBMapper != null ? 1 : 0) != 0, (String)"DynamoDBMapper not initialized", (Object[])new Object[0]);
        Tracker tracker = (Tracker)this.dynamoDBMapper.load(Tracker.class, (Object)this.trackerName);
        return Optional.ofNullable(tracker).map(t -> ((Tracker)t).sequenceNumber).orElse(0L);
    }

    public void updateLastConsumedSequenceNumber(long sequenceNumber) {
        Validate.isTrue((this.dynamoDBMapper != null ? 1 : 0) != 0, (String)"DynamoDBMapper not initialized", (Object[])new Object[0]);
        Validate.isTrue((sequenceNumber >= 0L ? 1 : 0) != 0, (String)"Illegal sequenceNumber [%d] - last consumed sequence number cannot be negative", (long)sequenceNumber);
        try {
            HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
            expected.put("name", new ExpectedAttributeValue().withExists(Boolean.valueOf(false)));
            expected.put("sequenceNumber", new ExpectedAttributeValue(new AttributeValue().withN(String.valueOf(sequenceNumber))).withComparisonOperator(ComparisonOperator.LT));
            this.dynamoDBMapper.save((Object)new Tracker(this.trackerName, sequenceNumber), new DynamoDBSaveExpression().withExpected(expected).withConditionalOperator(ConditionalOperator.OR));
        }
        catch (ConditionalCheckFailedException e) {
            throw new IllegalArgumentException(String.format("Illegal sequenceNumber [%d] - last consumed sequence number must be greater than current", sequenceNumber));
        }
    }

    public void reset() {
        this.dynamoDBMapper.save((Object)new Tracker(this.trackerName, 0L));
    }

    public static class Tracker {
        @DynamoDBHashKey(attributeName="name")
        private String name;
        @DynamoDBAttribute(attributeName="sequenceNumber")
        private long sequenceNumber;

        public Tracker() {
        }

        public Tracker(String name, long sequenceNumber) {
            this.name = name;
            this.sequenceNumber = sequenceNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }
}

