/*
 * Decompiled with CFR 0.152.
 */
package io.sdkman.maven;

import io.sdkman.maven.BaseMojo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="release")
public class ReleaseMojo
extends BaseMojo {
    @Parameter(property="sdkman.url")
    protected String url;
    @Parameter(property="sdkman.platforms")
    protected Map<String, String> platforms;

    @Override
    protected Map<String, String> getPayload() {
        if ((this.platforms == null || this.platforms.isEmpty()) && (this.url == null || this.url.isEmpty())) {
            throw new IllegalArgumentException("Missing url");
        }
        Map<String, String> payload = super.getPayload();
        payload.put("platform", "UNIVERSAL");
        payload.put("url", this.url);
        return payload;
    }

    @Override
    protected HttpEntityEnclosingRequestBase createHttpRequest() {
        try {
            return new HttpPost(this.createURI("/release"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            HttpResponse resp = this.executeRelease();
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new IllegalStateException("Server returned error " + resp.getStatusLine());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Sdk release failed", e);
        }
    }

    protected HttpResponse executeRelease() throws IOException {
        if (this.platforms == null || this.platforms.isEmpty()) {
            return this.execCall(this.getPayload(), this.createHttpRequest());
        }
        ArrayList<HttpResponse> responses = new ArrayList<HttpResponse>();
        for (Map.Entry<String, String> platform : this.platforms.entrySet()) {
            Map<String, String> payload = super.getPayload();
            payload.put("platform", platform.getKey());
            payload.put("url", platform.getValue());
            responses.add(this.execCall(payload, this.createHttpRequest()));
        }
        return responses.stream().filter(resp -> {
            int statusCode = resp.getStatusLine().getStatusCode();
            return statusCode < 200 || statusCode >= 300;
        }).findFirst().orElse((HttpResponse)responses.get(responses.size() - 1));
    }
}

