/*
 * Decompiled with CFR 0.152.
 */
package io.sdkman.maven;

import io.sdkman.maven.BaseMojo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="major-release")
public class MajorMojo
extends BaseMojo {
    @Parameter(property="sdkman.hashtag")
    protected String hashtag;
    @Parameter(property="sdkman.url")
    protected String url;
    @Parameter(property="sdkman.platforms")
    protected Map<String, String> platforms;
    @Parameter(property="sdkman.release.notes.url")
    protected String releaseNotesUrl;

    @Override
    protected HttpEntityEnclosingRequestBase createHttpRequest() {
        try {
            return new HttpPost(this.createURI("/release"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            HttpResponse resp = this.executeMajorRelease();
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new IllegalStateException("Server returned error " + resp.getStatusLine());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Sdk major release failed", e);
        }
    }

    protected HttpResponse executeMajorRelease() throws IOException {
        ArrayList<HttpResponse> responses = new ArrayList<HttpResponse>();
        if (this.platforms == null || this.platforms.isEmpty()) {
            responses.add(this.execCall(this.getReleasePayload(), this.createHttpRequest()));
        } else {
            for (Map.Entry<String, String> platform : this.platforms.entrySet()) {
                Map<String, String> payload = super.getPayload();
                payload.put("platform", platform.getKey());
                payload.put("url", platform.getValue());
                responses.add(this.execCall(payload, this.createHttpRequest()));
            }
        }
        responses.add(this.execCall(this.getAnnouncePayload(), this.createAnnounceHttpRequest()));
        responses.add(this.execCall(this.getPayload(), this.createDefaultHttpRequest()));
        return responses.stream().filter(resp -> {
            int statusCode = resp.getStatusLine().getStatusCode();
            return statusCode < 200 || statusCode >= 300;
        }).findFirst().orElse((HttpResponse)responses.get(responses.size() - 1));
    }

    protected Map<String, String> getAnnouncePayload() {
        Map<String, String> payload = super.getPayload();
        if (this.hashtag != null && !this.hashtag.isEmpty()) {
            payload.put("hashtag", this.hashtag);
        }
        if (this.releaseNotesUrl != null && !this.releaseNotesUrl.isEmpty()) {
            payload.put("url", this.releaseNotesUrl);
        }
        return payload;
    }

    protected Map<String, String> getReleasePayload() {
        Map<String, String> payload = super.getPayload();
        payload.put("platform", "UNIVERSAL");
        payload.put("url", this.url);
        return payload;
    }

    protected HttpEntityEnclosingRequestBase createAnnounceHttpRequest() {
        try {
            return new HttpPost(this.createURI("/announce/struct"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected HttpEntityEnclosingRequestBase createDefaultHttpRequest() {
        try {
            return new HttpPut(this.createURI("/default"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

