/*
 * Decompiled with CFR 0.152.
 */
package io.sdkman.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(property="sdkman.consumer.key", required=true)
    protected String consumerKey;
    @Parameter(property="sdkman.consumer.token", required=true)
    protected String consumerToken;
    @Parameter(property="sdkman.candidate", required=true)
    protected String candidate;
    @Parameter(property="sdkman.version", required=true)
    protected String version;
    @Parameter(property="sdkman.api.host", defaultValue="vendors.sdkman.io")
    protected String apiHost;
    @Parameter(property="sdkman.use.https", defaultValue="true")
    protected boolean https;
    @Parameter(property="sdkman.skip")
    private boolean skip;

    protected Map<String, String> getPayload() {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("candidate", this.candidate);
        payload.put("version", this.version);
        return payload;
    }

    protected abstract HttpEntityEnclosingRequestBase createHttpRequest();

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.doExecute();
        this.getLog().info((CharSequence)"Sdk vendor operation successful");
    }

    protected void doExecute() throws MojoExecutionException {
        try {
            HttpResponse resp = this.execCall(this.getPayload(), this.createHttpRequest());
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new IllegalStateException("Server returned error " + resp.getStatusLine());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Sdk vendor operation failed", e);
        }
    }

    protected HttpResponse execCall(Map<String, String> payload, HttpEntityEnclosingRequestBase req) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(payload);
        this.getLog().info((CharSequence)req.getURI().toString());
        this.getLog().info((CharSequence)json);
        req.addHeader("Consumer-Key", this.consumerKey);
        req.addHeader("Consumer-Token", this.consumerToken);
        req.addHeader("Content-Type", "application/json");
        req.addHeader("Accept", "application/json");
        req.setEntity((HttpEntity)new StringEntity(json));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = client.execute((HttpUriRequest)req);
        try (InputStream in = resp.getEntity().getContent();){
            Map sdkmanResp = (Map)mapper.readValue(in, Map.class);
            for (Map.Entry prop : sdkmanResp.entrySet()) {
                this.getLog().debug((CharSequence)((String)prop.getKey() + ":" + prop.getValue()));
            }
        }
        return resp;
    }

    protected URI createURI(String endpoint) throws URISyntaxException {
        String[] parts;
        String host = this.apiHost;
        int i = host.indexOf("://");
        if (i > -1) {
            host = host.substring(i + 3);
        }
        if ((parts = host.split(":")).length == 1) {
            return new URI(this.https ? "https" : "http", host, endpoint, null);
        }
        if (parts.length == 2) {
            return new URI(this.https ? "https" : "http", null, parts[0], Integer.parseInt(parts[1]), endpoint, null, null);
        }
        throw new URISyntaxException(this.apiHost, "Invalid");
    }
}

