/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.utils;

import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtils {
    private static final Logger LOG = LogManager.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static <T extends Annotation> Pair<Optional<Field>, T> findFieldByAnnotation(Class clazz, Class<T> clazzA) {
        Optional<Field> field = Arrays.stream(clazz.getDeclaredFields()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(clazzA::isInstance)).findFirst();
        return new Pair<Optional<Field>, Annotation>(field, field.map(f -> f.getDeclaredAnnotationsByType(clazzA)[0]).orElseThrow());
    }

    public static <T extends Annotation> List<Pair<Field, T>> getFieldsByAnnotation(Class clazz, Class<T> clzAnnotation) {
        List fields = Arrays.stream(clazz.getDeclaredFields()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(clzAnnotation::isInstance)).collect(Collectors.toList());
        return fields.stream().map(f -> new Pair<Field, Annotation>((Field)f, f.getDeclaredAnnotationsByType(clzAnnotation)[0])).collect(Collectors.toList());
    }

    public static <T extends Annotation> Optional<T> getClassLevelAnnotation(Class clazz, Class<T> annotation) {
        return Optional.ofNullable(clazz.getDeclaredAnnotation(annotation));
    }

    static Optional<Constructor> getDefaultConstructor(Class clazz) {
        try {
            return Optional.of(clazz.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            ExceptionUtils.rethrow(e, RuntimeException.class);
            LOG.error((Object)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> instanceOf(Class<T> clazz) {
        Constructor defaultConstructor = ReflectionUtils.getDefaultConstructor(clazz).orElseThrow();
        try {
            return Optional.of(defaultConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error((Object)e);
            return Optional.empty();
        }
    }

    public static <T> T executeMethod(Method method, Object declaring, Object ... args) {
        Objects.requireNonNull(method);
        try {
            return (T)method.invoke(declaring, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error(e.getCause().getMessage());
            throw new RuntimeException("Cannot invoke the method with step: " + method.getName() + "()", e);
        }
    }

    public static <T> T executeStaticMethod(Method method, Object ... args) {
        Objects.requireNonNull(method);
        try {
            return (T)method.invoke(null, args);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("@Prepare/@CleanUp annotation must be used on public static methods.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error(e.getCause().getMessage());
            throw new RuntimeException("Cannot invoke the method with step: " + method.getName() + "()", e);
        }
    }
}

