/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.source;

import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.source.FileBasedUserSourceImpl;
import io.ryos.rhino.sdk.users.source.VaultUserSourceImpl;
import java.util.List;
import java.util.Optional;

public interface UserSource {
    public List<User> getUsers();

    public List<User> getUsers(int var1, String var2);

    public static UserSource newSource() {
        UserSource userProvider = null;
        SourceType userSource = SimulationConfig.getUserSource();
        if (userSource.equals((Object)SourceType.VAULT)) {
            userProvider = new VaultUserSourceImpl();
        }
        if (userSource.equals((Object)SourceType.FILE)) {
            String filePath = Optional.ofNullable(SimulationConfig.getUserFileSource()).orElseThrow(() -> new RuntimeException("<env>.users.file property is missing."));
            userProvider = new FileBasedUserSourceImpl(filePath);
        }
        return userProvider;
    }

    public static enum SourceType {
        FILE,
        VAULT;

    }
}

