/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.repositories;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.exceptions.UserLoginException;
import io.ryos.rhino.sdk.users.data.OAuthService;
import io.ryos.rhino.sdk.users.repositories.ServiceAuthenticator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthServiceAuthenticatorImpl
implements ServiceAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthServiceAuthenticatorImpl.class);
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CODE = "code";
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public OAuthService authenticate(OAuthService service) {
        try {
            Client client;
            Response response;
            Form form = new Form();
            if (SimulationConfig.getClientId() != null) {
                form.param(CLIENT_ID, SimulationConfig.getServiceClientId());
            }
            if (SimulationConfig.getClientSecret() != null) {
                form.param(CLIENT_SECRET, SimulationConfig.getServiceClientSecret());
            }
            if (SimulationConfig.getGrantType() != null) {
                form.param(GRANT_TYPE, SimulationConfig.getServiceGrantType());
            }
            if (SimulationConfig.getClientCode() != null) {
                form.param(CODE, SimulationConfig.getServiceClientCode());
            }
            if ((response = (client = ClientBuilder.newClient()).target(SimulationConfig.getAuthServer()).request().post(Entity.form((Form)form))).getStatus() != Response.Status.OK.getStatusCode()) {
                LOG.info("Cannot login the service, status={} message={}", (Object)response.getStatus(), response.readEntity(String.class));
                return null;
            }
            String responseInString = (String)response.readEntity(String.class);
            LOG.debug(responseInString);
            return this.mapToEntity(responseInString);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow(e, UserLoginException.class, "Login failed.");
            return null;
        }
    }

    private OAuthService mapToEntity(String s) {
        OAuthService o;
        try {
            o = (OAuthService)this.objectMapper.readValue(s, OAuthService.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot map authorization server response to entity type: " + OAuthService.class.getName(), e);
        }
        return o;
    }
}

