/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.repositories;

import io.ryos.rhino.sdk.CyclicIterator;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.users.repositories.CyclicUserSessionRepository;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import java.util.List;
import java.util.Objects;

public class CyclicUserSessionRepositoryImpl
implements CyclicUserSessionRepository<UserSession> {
    public static final int MAX_NUMBER_OF_USERS = 1000;
    private final CyclicIterator<UserSession> filteredIterator;
    private final List<UserSession> backingList;

    public CyclicUserSessionRepositoryImpl(UserRepository<UserSession> userRepository, String region) {
        this(userRepository, region, 1000);
    }

    public CyclicUserSessionRepositoryImpl(UserRepository<UserSession> userRepository, String region, int maxNumberOfUsers) {
        Objects.requireNonNull(userRepository);
        Objects.requireNonNull(region);
        List<UserSession> filteredUsers = userRepository.leaseUsers(maxNumberOfUsers, region);
        this.backingList = filteredUsers;
        this.filteredIterator = new CyclicIterator<UserSession>(filteredUsers);
    }

    @Override
    public UserSession take() {
        UserSession next = this.filteredIterator.next();
        next.empty();
        return next;
    }

    public List<UserSession> getUserList() {
        return this.backingList;
    }
}

