/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users;

import io.ryos.rhino.sdk.users.UserParser;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.data.UserImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSVUserParserImpl
implements UserParser {
    private static final Logger LOG = LogManager.getLogger(CSVUserParserImpl.class);

    @Override
    public List<User> unmarshal(InputStream inputStream) {
        List<User> list;
        if (inputStream == null) {
            throw new RuntimeException("User file not found.");
        }
        ArrayList<User> userList = new ArrayList<User>();
        BufferedReader isr = new BufferedReader(new InputStreamReader(inputStream));
        try {
            list = isr.lines().map(line -> line.split(";")).filter(arr -> ((String[])arr).length == 4).map(arr -> new UserImpl(arr[0], arr[1], "user-" + UUID.randomUUID(), arr[2], arr[3])).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)e);
                return userList;
            }
        }
        isr.close();
        return list;
    }
}

