/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.specs;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.specs.AbstractSpec;
import io.ryos.rhino.sdk.specs.HttpConfigSpec;
import io.ryos.rhino.sdk.specs.HttpResponse;
import io.ryos.rhino.sdk.specs.HttpRetriableSpec;
import io.ryos.rhino.sdk.specs.HttpSpec;
import io.ryos.rhino.sdk.specs.MeasurableSpec;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class HttpSpecImpl
extends AbstractSpec
implements HttpSpec,
HttpConfigSpec,
HttpRetriableSpec {
    private Supplier<InputStream> toUpload;
    private List<Function<UserSession, Map.Entry<String, List<String>>>> headers = new ArrayList<Function<UserSession, Map.Entry<String, List<String>>>>();
    private List<Function<UserSession, Map.Entry<String, List<String>>>> queryParams = new ArrayList<Function<UserSession, Map.Entry<String, List<String>>>>();
    private boolean authEnabled;
    private HttpSpec.Method httpMethod;
    private Function<UserSession, String> endpoint;
    private RetryInfo retryInfo;
    private String saveTo;

    public HttpSpecImpl(String measurement) {
        super(measurement);
    }

    @Override
    public HttpRetriableSpec get() {
        this.httpMethod = HttpSpec.Method.GET;
        return this;
    }

    @Override
    public HttpRetriableSpec head() {
        this.httpMethod = HttpSpec.Method.HEAD;
        return this;
    }

    @Override
    public HttpRetriableSpec put() {
        this.httpMethod = HttpSpec.Method.PUT;
        return this;
    }

    @Override
    public HttpRetriableSpec patch() {
        this.httpMethod = HttpSpec.Method.PATCH;
        return this;
    }

    @Override
    public HttpRetriableSpec post() {
        this.httpMethod = HttpSpec.Method.POST;
        return this;
    }

    @Override
    public HttpRetriableSpec delete() {
        this.httpMethod = HttpSpec.Method.DELETE;
        return this;
    }

    @Override
    public HttpRetriableSpec options() {
        this.httpMethod = HttpSpec.Method.OPTIONS;
        return this;
    }

    @Override
    public HttpConfigSpec endpoint(String endpoint) {
        this.endpoint = r -> endpoint;
        return this;
    }

    @Override
    public HttpConfigSpec endpoint(Function<UserSession, String> endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public HttpConfigSpec header(String key, List<String> values) {
        this.headers.add(e -> Map.entry(key, values));
        return this;
    }

    @Override
    public HttpConfigSpec header(String key, String value) {
        this.headers.add(e -> Map.entry(key, Collections.singletonList(value)));
        return this;
    }

    @Override
    public HttpConfigSpec header(Function<UserSession, Map.Entry<String, List<String>>> headerFunction) {
        this.headers.add(headerFunction);
        return this;
    }

    @Override
    public HttpConfigSpec auth() {
        this.authEnabled = true;
        return this;
    }

    @Override
    public HttpConfigSpec queryParam(String key, List<String> values) {
        this.queryParams.add(e -> Map.entry(key, values));
        return this;
    }

    @Override
    public HttpConfigSpec queryParam(String key, String value) {
        this.queryParams.add(e -> Map.entry(key, Collections.singletonList(value)));
        return this;
    }

    @Override
    public HttpConfigSpec queryParam(Function<UserSession, Map.Entry<String, List<String>>> headerFunction) {
        this.queryParams.add(headerFunction);
        return this;
    }

    @Override
    public HttpConfigSpec upload(Supplier<InputStream> inputStream) {
        this.toUpload = inputStream;
        return this;
    }

    @Override
    public MeasurableSpec retryIf(Predicate<HttpResponse> predicate, int numOfRetries) {
        this.retryInfo = new RetryInfo(predicate, numOfRetries);
        return this;
    }

    @Override
    public HttpSpec saveTo(String keyName) {
        this.saveTo = keyName;
        return this;
    }

    @Override
    public Supplier<InputStream> getUploadContent() {
        return this.toUpload;
    }

    @Override
    public HttpSpec.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public List<Function<UserSession, Map.Entry<String, List<String>>>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<Function<UserSession, Map.Entry<String, List<String>>>> getQueryParameters() {
        return this.queryParams;
    }

    @Override
    public Function<UserSession, String> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean isAuth() {
        return this.authEnabled;
    }

    @Override
    public String getResponseKey() {
        return this.saveTo;
    }

    @Override
    public RetryInfo getRetryInfo() {
        return this.retryInfo;
    }

    public static class RetryInfo {
        private Predicate<HttpResponse> predicate;
        private int numOfRetries;

        RetryInfo(Predicate<HttpResponse> predicate, int numOfRetries) {
            this.predicate = predicate;
            this.numOfRetries = numOfRetries;
        }

        public Predicate<HttpResponse> getPredicate() {
            return this.predicate;
        }

        public int getNumOfRetries() {
            return this.numOfRetries;
        }
    }
}

