/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.specs;

import io.netty.handler.codec.http.HttpHeaders;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.reporting.MeasurementImpl;
import io.ryos.rhino.sdk.reporting.UserEvent;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.specs.HttpResponse;
import io.ryos.rhino.sdk.specs.HttpSpec;
import io.ryos.rhino.sdk.specs.HttpSpecImpl;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.request.NettyRequest;

public class HttpSpecAsyncHandler
implements AsyncHandler<Response> {
    private final String stepName;
    private final String specName;
    private final String userId;
    private final boolean measurementEnabled;
    private final boolean cumulativeMeasurement;
    private final MeasurementImpl measurement;
    private volatile long start = -1L;
    private volatile int status;
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();
    private final EventDispatcher eventDispatcher;
    private final HttpSpecImpl.RetryInfo retryInfo;

    public HttpSpecAsyncHandler(UserSession session, HttpSpec spec, EventDispatcher eventDispatcher) {
        this.measurement = new MeasurementImpl(spec.getTestName(), session.getUser().getId());
        this.specName = spec.getTestName();
        this.userId = session.getUser().getId();
        this.stepName = spec.getMeasurementPoint();
        this.eventDispatcher = eventDispatcher;
        this.measurementEnabled = spec.isMeasurementEnabled();
        this.retryInfo = spec.getRetryInfo();
        this.cumulativeMeasurement = spec.isCumulativeMeasurement();
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
        this.builder.reset();
        this.builder.accumulate(responseStatus);
        this.status = responseStatus.getStatusCode();
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        this.builder.accumulate(bodyPart);
        return AsyncHandler.State.CONTINUE;
    }

    public void onThrowable(Throwable t) {
        if (!this.measurementEnabled) {
            this.start = System.currentTimeMillis();
            UserEvent userEventStart = new UserEvent();
            userEventStart.elapsed = 0L;
            userEventStart.start = this.start;
            userEventStart.end = this.start;
            userEventStart.scenario = this.specName;
            userEventStart.eventType = UserEvent.EventType.START;
            userEventStart.id = this.userId;
            this.measurement.record(userEventStart);
        }
        this.measurement.measure(t.getMessage(), "N/A");
        UserEvent userEventEnd = new UserEvent();
        userEventEnd.elapsed = 0L;
        userEventEnd.start = this.start;
        userEventEnd.end = 0L;
        userEventEnd.scenario = this.specName;
        userEventEnd.eventType = UserEvent.EventType.END;
        userEventEnd.id = this.userId;
        this.measurement.record(userEventEnd);
        this.eventDispatcher.dispatchEvents(this.measurement);
    }

    public Response onCompleted() {
        Response response = this.builder.build();
        HttpResponse httpResponse = new HttpResponse(response);
        if (this.measurementEnabled && this.isReadyToMeasure(httpResponse)) {
            this.completeMeasurement();
        }
        return response;
    }

    public void completeMeasurement() {
        long elapsed = System.currentTimeMillis() - this.start;
        this.measurement.measure(this.stepName, String.valueOf(this.status));
        UserEvent userEventEnd = new UserEvent();
        userEventEnd.elapsed = elapsed;
        userEventEnd.start = this.start;
        userEventEnd.end = this.start + elapsed;
        userEventEnd.scenario = this.specName;
        userEventEnd.eventType = UserEvent.EventType.END;
        userEventEnd.id = this.userId;
        this.measurement.record(userEventEnd);
        this.eventDispatcher.dispatchEvents(this.measurement);
    }

    private boolean isReadyToMeasure(HttpResponse httpResponse) {
        if (this.retryInfo == null) {
            return true;
        }
        if (!this.cumulativeMeasurement) {
            return true;
        }
        return !this.retryInfo.getPredicate().test(httpResponse);
    }

    public void onRequestSend(NettyRequest request) {
        if (this.measurementEnabled) {
            if (this.start < 0L || !this.cumulativeMeasurement) {
                this.start = System.currentTimeMillis();
            }
            UserEvent userEventStart = new UserEvent();
            userEventStart.elapsed = 0L;
            userEventStart.start = this.start;
            userEventStart.end = this.start;
            userEventStart.scenario = this.specName;
            userEventStart.eventType = UserEvent.EventType.START;
            userEventStart.id = this.userId;
            this.measurement.record(userEventStart);
        }
    }
}

