/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.annotations.UserProvider;
import io.ryos.rhino.sdk.data.InjectionPoint;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.providers.OAuthUserProvider;
import io.ryos.rhino.sdk.providers.Provider;
import io.ryos.rhino.sdk.runners.AbstractSimulationInjector;
import io.ryos.rhino.sdk.users.repositories.CyclicUserSessionRepositoryImpl;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReactiveRunnerSimulationInjector
extends AbstractSimulationInjector {
    private static final Logger LOG = LogManager.getLogger(ReactiveRunnerSimulationInjector.class);
    private final SimulationMetadata simulationMetadata;
    private final UserSession userSession;

    public ReactiveRunnerSimulationInjector(SimulationMetadata simulationMetadata, UserSession userSession) {
        this.simulationMetadata = Objects.requireNonNull(simulationMetadata);
        this.userSession = userSession;
    }

    @Override
    public void injectOn(Object injectable) {
        this.injectUserProvider(injectable);
        this.injectCustomFeeders(injectable);
    }

    private void injectUserProvider(Object simulationInstance) {
        List<Pair<Field, UserProvider>> fieldAnnotation = ReflectionUtils.getFieldsByAnnotation(this.simulationMetadata.getSimulationClass(), UserProvider.class);
        fieldAnnotation.stream().map(pair -> new Pair<OAuthUserProvider, Field>(new OAuthUserProvider(new CyclicUserSessionRepositoryImpl(this.simulationMetadata.getUserRepository(), ((UserProvider)pair.getSecond()).region())), (Field)pair.getFirst())).forEach(r -> this.setValueToInjectionPoint((OAuthUserProvider)r.getFirst(), (Field)r.getSecond(), simulationInstance));
    }

    private void injectCustomFeeders(Object simulationInstance) {
        Arrays.stream(this.simulationMetadata.getSimulationClass().getDeclaredFields()).filter(this.hasFeeder).map(this.injectionPointFunction).forEach(ip -> this.feed(simulationInstance, (InjectionPoint<io.ryos.rhino.sdk.annotations.Provider>)ip));
    }

    @Override
    protected void feed(Object instance, InjectionPoint<io.ryos.rhino.sdk.annotations.Provider> injectionPoint) {
        Objects.requireNonNull(instance, "Object instance is null.");
        Provider factoryInstance = ReflectionUtils.instanceOf(injectionPoint.getAnnotation().factory()).orElseThrow();
        try {
            Field field = injectionPoint.getField();
            field.setAccessible(true);
            field.set(instance, factoryInstance);
        }
        catch (IllegalAccessException e) {
            LOG.error("Access to field failed.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Provider's return type and field's type is not compatible: " + e.getMessage());
        }
    }
}

