/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.annotations.Provider;
import io.ryos.rhino.sdk.annotations.SessionFeeder;
import io.ryos.rhino.sdk.annotations.UserProvider;
import io.ryos.rhino.sdk.data.InjectionPoint;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.providers.OAuthUserProvider;
import io.ryos.rhino.sdk.runners.AbstractSimulationInjector;
import io.ryos.rhino.sdk.users.repositories.CyclicUserSessionRepositoryImpl;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DefaultRunnerSimulationInjector
extends AbstractSimulationInjector {
    private final SimulationMetadata simulationMetadata;
    private final UserSession userSession;

    public DefaultRunnerSimulationInjector(SimulationMetadata simulationMetadata, UserSession userSession) {
        this.simulationMetadata = Objects.requireNonNull(simulationMetadata);
        this.userSession = userSession;
    }

    @Override
    public void injectOn(Object injectable) {
        Objects.requireNonNull(injectable);
        this.injectUser(injectable);
        this.injectCustomFeeders(injectable);
    }

    void injectSession(UserSession userSession) {
        List<Pair<Field, SessionFeeder>> fieldAnnotation = ReflectionUtils.getFieldsByAnnotation(this.simulationMetadata.getSimulationClass(), SessionFeeder.class);
        fieldAnnotation.forEach(f -> this.setValueToInjectionPoint(null, (Field)f.getFirst(), this.simulationMetadata.getTestInstance()));
    }

    private void injectUser(Object simulationInstance) {
        List<Pair<Field, UserProvider>> fieldAnnotation = ReflectionUtils.getFieldsByAnnotation(this.simulationMetadata.getSimulationClass(), UserProvider.class);
        fieldAnnotation.stream().map(pair -> new Pair<OAuthUserProvider, Field>(new OAuthUserProvider(new CyclicUserSessionRepositoryImpl(this.simulationMetadata.getUserRepository(), ((UserProvider)pair.getSecond()).region())), (Field)pair.getFirst())).forEach(r -> this.setValueToInjectionPoint((OAuthUserProvider)r.getFirst(), (Field)r.getSecond(), simulationInstance));
    }

    private void injectCustomFeeders(Object simulationInstance) {
        Arrays.stream(this.simulationMetadata.getSimulationClass().getDeclaredFields()).filter(this.hasFeeder).map(this.injectionPointFunction).forEach(ip -> this.feed(simulationInstance, (InjectionPoint<Provider>)ip));
    }
}

