/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.data.Scenario;
import io.ryos.rhino.sdk.monitoring.GrafanaGateway;
import io.ryos.rhino.sdk.runners.SimulationRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimulationRunner
implements SimulationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSimulationRunner.class);
    private final SimulationMetadata simulationMetadata;

    public AbstractSimulationRunner(SimulationMetadata simulationMetadata) {
        this.simulationMetadata = simulationMetadata;
    }

    protected void setUpGrafanaDashboard() {
        LOG.info("Grafana is enabled. Creating dashboard: " + SimulationConfig.getSimulationId());
        new GrafanaGateway(this.simulationMetadata.getGrafanaInfo()).setUpDashboard(SimulationConfig.getSimulationId(), (String[])this.simulationMetadata.getScenarios().stream().map(Scenario::getDescription).toArray(String[]::new));
    }

    public SimulationMetadata getSimulationMetadata() {
        return this.simulationMetadata;
    }
}

