/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.data.InjectionPoint;
import io.ryos.rhino.sdk.providers.Provider;
import io.ryos.rhino.sdk.runners.SimulationInjector;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSimulationInjector
implements SimulationInjector {
    private static final Logger LOG = LogManager.getLogger(AbstractSimulationInjector.class);
    final Predicate<Field> hasFeeder = f -> Arrays.stream(f.getDeclaredAnnotations()).anyMatch(io.ryos.rhino.sdk.annotations.Provider.class::isInstance);
    final Function<Field, InjectionPoint<io.ryos.rhino.sdk.annotations.Provider>> injectionPointFunction = f -> new InjectionPoint<io.ryos.rhino.sdk.annotations.Provider>((Field)f, f.getDeclaredAnnotation(io.ryos.rhino.sdk.annotations.Provider.class));

    <T> void setValueToInjectionPoint(T object, Field f, Object simulationInstance) {
        try {
            f.setAccessible(true);
            f.set(simulationInstance, object);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
    }

    protected void feed(Object instance, InjectionPoint<io.ryos.rhino.sdk.annotations.Provider> injectionPoint) {
        Objects.requireNonNull(instance, "Object instance is null.");
        Provider factoryInstance = ReflectionUtils.instanceOf(injectionPoint.getAnnotation().factory()).orElseThrow();
        Object value = factoryInstance.take();
        try {
            Field field = injectionPoint.getField();
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            LOG.error("Access to field failed.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Provider's return type and field's type is not compatible: " + e.getMessage());
        }
    }
}

