/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.reporting;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import io.ryos.rhino.sdk.reporting.ScenarioEvent;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdoutReporter
extends AbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(StdoutReporter.class);
    private static final long DELAY = 1000L;
    private static final long PERIOD = 5000L;
    private static final String BORDER_LINE_BOLD = "==========================================================================";
    private static final String DATETIME_PATTERN = "HH:mm:ss";
    private static final String NOT_AVAILABLE = "N/A";
    private static final int MSG_OK = 200;
    private static final String COUNT = "Count/";
    private static final String RESPONSE_TIME = "ResponseTime/";
    private Instant startTime;
    private Duration duration;
    private int numberOfUsers;
    private volatile boolean receivedTerminationEvent = false;
    private Timer timer;
    private final Map<String, Long> metrics = new HashMap<String, Long>();

    public static Props props(int numberOfUsers, Instant startTime, Duration duration) {
        return Props.create(StdoutReporter.class, (Creator & Serializable)() -> new StdoutReporter(numberOfUsers, startTime, duration));
    }

    private StdoutReporter(int numberOfUsers, Instant startTime, Duration duration) {
        this.duration = duration;
        this.numberOfUsers = numberOfUsers;
        this.startTime = startTime;
        this.timer = new Timer("Stdout Report Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                StdoutReporter.this.flushReport(null);
            }
        };
        this.timer.schedule(timerTask, 1000L, 5000L);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ScenarioEvent.class, this::persist).match(EndTestEvent.class, this::activateTermination).build();
    }

    private void activateTermination(EndTestEvent endEvent) {
        if (this.receivedTerminationEvent) {
            this.sender().tell((Object)200, this.self());
            return;
        }
        this.flushReport(endEvent);
        this.receivedTerminationEvent = true;
        this.timer.cancel();
        this.sender().tell((Object)200, this.self());
    }

    private void persist(ScenarioEvent logEvent) {
        String countKey = String.format("Count/%s/%s/%s", logEvent.scenario, logEvent.step, logEvent.status);
        String responseTypeKey = String.format("ResponseTime/%s/%s/%s", logEvent.scenario, logEvent.step, logEvent.status);
        if (!this.metrics.containsKey(countKey)) {
            this.metrics.put(countKey, 0L);
        }
        if (!this.metrics.containsKey(responseTypeKey)) {
            this.metrics.put(responseTypeKey, 0L);
        }
        Long currVal = this.metrics.get(countKey);
        currVal = currVal + 1L;
        this.metrics.put(countKey, currVal);
        Long currElapsed = this.metrics.get(responseTypeKey);
        this.metrics.put(responseTypeKey, currElapsed + logEvent.elapsed);
    }

    private void flushReport(EndTestEvent event) {
        if (this.metrics.isEmpty()) {
            LOG.info("There is no record in measurement yet. Test is running...");
            return;
        }
        List countMetrics = this.metrics.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(COUNT)).map(e -> this.formatKey((String)e.getKey()) + " " + e.getValue()).collect(Collectors.toList());
        List responseTypeMetrics = this.metrics.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(RESPONSE_TIME)).map(e -> this.formatKey((String)e.getKey()) + " " + this.getAvgResponseTime((String)e.getKey(), (Long)e.getValue()) + " ms").collect(Collectors.toList());
        long overAllResponseTime = this.metrics.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(RESPONSE_TIME)).map(Map.Entry::getValue).reduce(Long::sum).orElse(0L);
        long totalNumberOfRequests = this.metrics.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(COUNT)).map(Map.Entry::getValue).reduce(Long::sum).orElse(0L);
        long avgRT = -1L;
        if (totalNumberOfRequests > 0L) {
            avgRT = overAllResponseTime / totalNumberOfRequests;
        }
        StringBuilder output = new StringBuilder();
        if (this.numberOfUsers > 0) {
            output.append("Number of users logged in : ").append(this.numberOfUsers).append('\n');
        }
        output.append("Tests started : ").append(this.formatDate(this.startTime)).append('\n');
        output.append("Elapsed : ").append(Duration.between(this.startTime, Instant.now()).toSeconds()).append(" secs ETA : ").append(this.formatDate(this.startTime.plus(this.duration))).append(" (duration ").append(this.duration.toMinutes()).append(" mins)").append('\n');
        if (event != null) {
            output.append("Tests ended : ").append(this.formatDate(event.getEndTestTime())).append('\n');
        }
        output.append(BORDER_LINE_BOLD).append('\n');
        output.append("-- Number of executions --------------------------------------------------").append('\n');
        output.append(String.join((CharSequence)"\n", countMetrics)).append('\n');
        output.append("-- Response Time ---------------------------------------------------------").append('\n');
        output.append(String.join((CharSequence)"\n", responseTypeMetrics)).append('\n').append('\n');
        output.append(BORDER_LINE_BOLD).append('\n');
        output.append(String.format("%50s %9s ms", "Average Response Time", avgRT)).append('\n');
        output.append(String.format("%50s %9s ", "Total Request", totalNumberOfRequests)).append('\n');
        output.append(BORDER_LINE_BOLD).append('\n');
        LOG.info(output.toString());
    }

    private String formatDate(Instant dateTime) {
        if (dateTime == null) {
            return NOT_AVAILABLE;
        }
        return DateTimeFormatter.ofPattern(DATETIME_PATTERN).withZone(ZoneId.systemDefault()).format(dateTime);
    }

    private long getAvgResponseTime(String key, long totalElapsed) {
        Long totalCount = this.metrics.get(key.replace(RESPONSE_TIME, COUNT));
        if (totalCount > 0L) {
            return totalElapsed / totalCount;
        }
        return -1L;
    }

    private String formatKey(String key) {
        String normalizedStr = key.replace(RESPONSE_TIME, "").replace(COUNT, "");
        Object[] split = normalizedStr.split("/");
        return String.format("> %-15.15s  %-15.15s %25s", split);
    }

    public static class EndTestEvent {
        private final Instant endTestTime;

        public EndTestEvent(Instant endTestTime) {
            this.endTestTime = endTestTime;
        }

        public Instant getEndTestTime() {
            return this.endTestTime;
        }
    }
}

