/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.reporting;

import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.Measurement;
import io.ryos.rhino.sdk.reporting.ScenarioEvent;
import java.util.ArrayList;
import java.util.List;

public class MeasurementImpl
implements Measurement {
    private final List<LogEvent> events = new ArrayList<LogEvent>();
    private final String scenarioName;
    private final String userId;

    public MeasurementImpl(String scenarioName, String userId) {
        this.scenarioName = scenarioName;
        this.userId = userId;
    }

    @Override
    public void measure(String stepName, String status) {
        if (this.events.isEmpty()) {
            ScenarioEvent simLog = new ScenarioEvent();
            simLog.elapsed = 0L;
            simLog.start = 0L;
            simLog.end = 0L;
            simLog.step = stepName;
            simLog.scenario = this.scenarioName;
            simLog.userId = this.userId;
            simLog.status = status;
            this.addEvent(simLog);
        } else {
            long end = System.currentTimeMillis();
            LogEvent lastEvent = this.events.get(this.events.size() - 1);
            long start = lastEvent.end;
            ScenarioEvent simLog = new ScenarioEvent();
            simLog.elapsed = end - start;
            simLog.start = start;
            simLog.end = end;
            simLog.step = stepName;
            simLog.scenario = this.scenarioName;
            simLog.userId = this.userId;
            simLog.status = status;
            this.addEvent(simLog);
        }
    }

    private synchronized void addEvent(ScenarioEvent event) {
        this.events.add(event);
    }

    @Override
    public void record(LogEvent event) {
        this.events.add(event);
    }

    public List<LogEvent> getEvents() {
        return this.events;
    }

    @Override
    public synchronized void purge() {
        this.events.clear();
    }
}

