/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.monitoring;

import io.ryos.rhino.sdk.GrafanaInfo;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.exceptions.RhinoIOException;
import io.ryos.rhino.sdk.io.ConfigResource;
import io.ryos.rhino.sdk.monitoring.GrafanaDashboard;
import io.ryos.rhino.sdk.monitoring.GrafanaSetupException;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class GrafanaGateway {
    private static final String TARGET = SimulationConfig.getGrafanaEndpoint() + "/api/dashboards/db";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private final GrafanaInfo grafanaInfo;

    public GrafanaGateway(GrafanaInfo grafanaInfo) {
        this.grafanaInfo = Objects.requireNonNull(grafanaInfo);
    }

    public void setUpDashboard(String simulationName, String ... scenarios) {
        Response createDashboardResponse;
        String dbTemplate = this.getDashboardJson(simulationName, scenarios);
        Invocation.Builder request = ClientBuilder.newClient().target(this.getUri()).request();
        if (this.getStrippedToken() != null) {
            request = request.header(HEADER_AUTHORIZATION, (Object)("Bearer " + this.getStrippedToken()));
        }
        if ((createDashboardResponse = request.post(Entity.entity((Object)dbTemplate, (String)"application/json"))).getStatus() != Response.Status.OK.getStatusCode() && createDashboardResponse.getStatus() != Response.Status.PRECONDITION_FAILED.getStatusCode()) {
            throw new GrafanaSetupException("Server response was : " + createDashboardResponse.getStatus());
        }
    }

    private String getDashboardJson(String simulationName, String[] scenarios) {
        String string;
        ConfigResource configResource = new ConfigResource(this.grafanaInfo.getPathToTemplate());
        BufferedReader reader = new BufferedReader(new InputStreamReader(configResource.getInputStream()));
        try {
            String template = reader.lines().collect(Collectors.joining("\n"));
            Optional<? extends GrafanaDashboard> grafanaDashboard = ReflectionUtils.instanceOf(this.grafanaInfo.getDashboard());
            string = grafanaDashboard.map(d -> d.getDashboard(simulationName, template, scenarios)).orElseThrow(IllegalArgumentException::new);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RhinoIOException("Cannot create dashboard.");
            }
        }
        reader.close();
        return string;
    }

    private String getStrippedToken() {
        String grafanaToken = SimulationConfig.getGrafanaToken();
        if (grafanaToken == null || grafanaToken.length() == 0) {
            return null;
        }
        if (grafanaToken.length() < 2) {
            throw new RuntimeException("Invalid Grafana token.");
        }
        return SimulationConfig.getGrafanaToken().substring(1, SimulationConfig.getGrafanaToken().length() - 1);
    }

    private URI getUri() {
        try {
            return new URI(TARGET);
        }
        catch (URISyntaxException e) {
            ExceptionUtils.rethrow(e, GrafanaSetupException.class);
            return null;
        }
    }
}

