/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import io.ryos.rhino.sdk.exceptions.ConfigurationNotFoundException;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ConfigResource {
    private static final String SEPARATOR = "://";
    private final String sourceURI;
    private final Function<String, InputStream> classpathResourcePointer = path -> Optional.ofNullable(this.getClass().getResourceAsStream((String)path)).orElseThrow(() -> new ConfigurationNotFoundException((String)path));
    private final Function<String, InputStream> fileResourcePointer = path -> {
        Path filePath = Path.of(path, new String[0]);
        File file = filePath.toFile();
        if (file.isFile() && file.exists() && file.canRead()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                ExceptionUtils.rethrow(e, ConfigurationNotFoundException.class, "Unexpected file not found in path:" + filePath.toString());
            }
        }
        throw new ConfigurationNotFoundException((String)path);
    };

    public ConfigResource(String sourceURI) {
        this.sourceURI = Objects.requireNonNull(sourceURI);
    }

    public InputStream getInputStream() {
        String[] split = this.sourceURI.split(SEPARATOR);
        String sourceType = split[0].toUpperCase();
        String pathToSource = split[1];
        switch (Type.valueOf(sourceType)) {
            case CLASSPATH: {
                return this.classpathResourcePointer.apply(pathToSource);
            }
            case FILE: {
                return this.fileResourcePointer.apply(pathToSource);
            }
        }
        throw new UnsupportedOperationException("Rhino knows only about classpath files or files on file system.");
    }

    public static enum Type {
        CLASSPATH,
        FILE;

    }
}

