/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.exceptions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionUtils {
    private static final Logger LOG = LogManager.getLogger(ExceptionUtils.class);

    public static void rethrow(Exception e, Class<? extends RuntimeException> exception, String message) {
        try {
            if (exception.getDeclaredConstructor(Throwable.class, String.class) != null) {
                Constructor<? extends RuntimeException> declaredConstructor = exception.getDeclaredConstructor(Throwable.class, String.class);
                throw declaredConstructor.newInstance(e, message);
            }
            Constructor<? extends RuntimeException> declaredConstructor = exception.getDeclaredConstructor(Throwable.class);
            throw declaredConstructor.newInstance(e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error((Object)ex);
            return;
        }
    }

    public static void rethrow(Exception e, Class<? extends RuntimeException> exception) {
        ExceptionUtils.rethrow(e, exception, null);
    }
}

