/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.HttpSpecMaterializer;
import io.ryos.rhino.sdk.dsl.LoopSpecMaterializer;
import io.ryos.rhino.sdk.dsl.MapperSpecMaterializer;
import io.ryos.rhino.sdk.dsl.SomeSpecMaterializer;
import io.ryos.rhino.sdk.dsl.WaitSpecMaterializer;
import io.ryos.rhino.sdk.exceptions.MaterializerNotFound;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.specs.ConditionalSpecWrapper;
import io.ryos.rhino.sdk.specs.HttpSpec;
import io.ryos.rhino.sdk.specs.LoopSpec;
import io.ryos.rhino.sdk.specs.MapperSpec;
import io.ryos.rhino.sdk.specs.SomeSpec;
import io.ryos.rhino.sdk.specs.Spec;
import io.ryos.rhino.sdk.specs.WaitSpec;
import org.asynchttpclient.AsyncHttpClient;
import reactor.core.publisher.Mono;

public class MaterializerFactory {
    private final AsyncHttpClient httpClient;
    private final EventDispatcher eventDispatcher;

    public MaterializerFactory(AsyncHttpClient httpClient, EventDispatcher dispatcher) {
        this.httpClient = httpClient;
        this.eventDispatcher = dispatcher;
    }

    public Mono<UserSession> monoFrom(Spec spec, UserSession session) {
        if (spec instanceof HttpSpec) {
            return new HttpSpecMaterializer(this.httpClient, this.eventDispatcher).materialize((HttpSpec)spec, session);
        }
        if (spec instanceof SomeSpec) {
            return new SomeSpecMaterializer(this.eventDispatcher).materialize((SomeSpec)spec, session);
        }
        if (spec instanceof WaitSpec) {
            return new WaitSpecMaterializer().materialize((WaitSpec)spec, session);
        }
        if (spec instanceof MapperSpec) {
            return new MapperSpecMaterializer().materialize((MapperSpec)spec, session);
        }
        if (spec instanceof LoopSpec) {
            return new LoopSpecMaterializer(this.eventDispatcher, this.httpClient).materialize((LoopSpec)spec, session);
        }
        if (this.isConditionalSpec(spec)) {
            return this.monoFrom(((ConditionalSpecWrapper)spec).getSpec(), session);
        }
        throw new MaterializerNotFound("Materializer not found for spec: " + spec.getClass().getName());
    }

    private boolean isConditionalSpec(Spec next) {
        return next instanceof ConditionalSpecWrapper;
    }
}

