/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.MaterializerFactory;
import io.ryos.rhino.sdk.dsl.SpecMaterializer;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.specs.ConditionalSpecWrapper;
import io.ryos.rhino.sdk.specs.LoopSpec;
import io.ryos.rhino.sdk.specs.Spec;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.asynchttpclient.AsyncHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class LoopSpecMaterializer<E, R extends Iterable<E>>
implements SpecMaterializer<LoopSpec<E, R>, UserSession> {
    private static final Logger LOG = LoggerFactory.getLogger(LoopSpecMaterializer.class);
    private final EventDispatcher eventDispatcher;
    private final AsyncHttpClient asyncHttpClient;

    public LoopSpecMaterializer(EventDispatcher eventDispatcher, AsyncHttpClient asyncHttpClient) {
        this.eventDispatcher = eventDispatcher;
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public Mono<UserSession> materialize(LoopSpec<E, R> spec, UserSession session) {
        String key = spec.getLoopBuilder().getKey();
        Optional es = session.get(key);
        if (es.isEmpty()) {
            return Mono.empty();
        }
        Iterable it = (Iterable)es.get();
        MaterializerFactory materializerFactory = new MaterializerFactory(this.asyncHttpClient, this.eventDispatcher);
        Function loopFunction = spec.getLoopBuilder().getLoopFunction();
        Iterator inputIt = it.iterator();
        Mono acc = materializerFactory.monoFrom(loopFunction.apply(inputIt.next()), session);
        while (inputIt.hasNext()) {
            Object next = inputIt.next();
            acc = acc.flatMap(s -> {
                Predicate<UserSession> predicate;
                if (next instanceof ConditionalSpecWrapper && !(predicate = ((ConditionalSpecWrapper)next).getPredicate()).test((UserSession)s)) {
                    return Mono.just((Object)s);
                }
                return materializerFactory.monoFrom((Spec)loopFunction.apply(next), session);
            });
        }
        acc = acc.doOnError(e -> LOG.error("Unexpected error: ", e));
        return acc;
    }
}

