/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.SpecMaterializer;
import io.ryos.rhino.sdk.exceptions.RetryFailedException;
import io.ryos.rhino.sdk.exceptions.RetryableOperationException;
import io.ryos.rhino.sdk.exceptions.UnknownTokenTypeException;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.specs.HttpResponse;
import io.ryos.rhino.sdk.specs.HttpSpec;
import io.ryos.rhino.sdk.specs.HttpSpecAsyncHandler;
import io.ryos.rhino.sdk.specs.HttpSpecImpl;
import io.ryos.rhino.sdk.users.data.OAuthService;
import io.ryos.rhino.sdk.users.data.OAuthUser;
import io.ryos.rhino.sdk.users.data.User;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpSpecMaterializer
implements SpecMaterializer<HttpSpec, UserSession> {
    private static final Logger LOG = LogManager.getLogger(HttpSpecMaterializer.class);
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final String USER = "user";
    private static final String SERVICE = "service";
    private final AsyncHttpClient client;
    private final EventDispatcher eventDispatcher;
    private final Predicate<UserSession> conditionalSpec;

    public HttpSpecMaterializer(AsyncHttpClient client, EventDispatcher eventDispatcher, Predicate<UserSession> predicate) {
        this.client = client;
        this.eventDispatcher = eventDispatcher;
        this.conditionalSpec = predicate;
    }

    public HttpSpecMaterializer(AsyncHttpClient client, EventDispatcher eventDispatcher) {
        this(client, eventDispatcher, null);
    }

    @Override
    public Mono<UserSession> materialize(HttpSpec spec, UserSession userSession) {
        if (this.conditionalSpec != null && !this.conditionalSpec.test(userSession)) {
            return Mono.just((Object)userSession);
        }
        HttpSpecAsyncHandler httpSpecAsyncHandler = new HttpSpecAsyncHandler(userSession, spec, this.eventDispatcher);
        Mono responseMono = Mono.just((Object)userSession).flatMap(s -> Mono.fromCompletionStage((CompletionStage)this.client.executeRequest(this.buildRequest(spec, (UserSession)s), (AsyncHandler)httpSpecAsyncHandler).toCompletableFuture()));
        Mono retriableMono = Optional.ofNullable(spec.getRetryInfo()).map(retryInfo -> responseMono.map(HttpResponse::new).map(hr -> this.isRetriable((HttpSpecImpl.RetryInfo)retryInfo, (HttpResponse)hr)).retryWhen(companion -> companion.zipWith((Publisher)Flux.range((int)1, (int)(retryInfo.getNumOfRetries() + 1)), (error, index) -> {
            if (index < retryInfo.getNumOfRetries() + 1 && error instanceof RetryableOperationException) {
                return index;
            }
            throw Exceptions.propagate((Throwable)new RetryFailedException((Throwable)error));
        }))).orElse(responseMono);
        return retriableMono.map(response -> (UserSession)userSession.add(Optional.ofNullable(spec.getResponseKey()).orElse("result"), response)).onErrorResume(error -> {
            if (error instanceof RetryFailedException && spec.isCumulativeMeasurement()) {
                httpSpecAsyncHandler.completeMeasurement();
            }
            return Mono.empty();
        }).doOnError(t -> LOG.error("Http Client Error", t));
    }

    private Response isRetriable(HttpSpecImpl.RetryInfo retryInfo, HttpResponse hr) {
        if (retryInfo.getPredicate().test(hr)) {
            throw new RetryableOperationException(String.valueOf(hr.getStatusCode()));
        }
        return hr.getResponse();
    }

    private RequestBuilder buildRequest(HttpSpec httpSpec, UserSession userSession) {
        RequestBuilder builder = null;
        switch (httpSpec.getMethod()) {
            case GET: {
                builder = Dsl.get((String)httpSpec.getEndpoint().apply(userSession));
                break;
            }
            case HEAD: {
                builder = Dsl.head((String)httpSpec.getEndpoint().apply(userSession));
                break;
            }
            case OPTIONS: {
                builder = Dsl.options((String)httpSpec.getEndpoint().apply(userSession));
                break;
            }
            case DELETE: {
                builder = Dsl.delete((String)httpSpec.getEndpoint().apply(userSession));
                break;
            }
            case PUT: {
                builder = (RequestBuilder)Dsl.put((String)httpSpec.getEndpoint().apply(userSession)).setBody(httpSpec.getUploadContent().get());
                break;
            }
            case POST: {
                builder = (RequestBuilder)Dsl.put((String)httpSpec.getEndpoint().apply(userSession)).setBody(httpSpec.getUploadContent().get());
                break;
            }
            default: {
                throw new NotImplementedException("Not implemented: " + httpSpec.getMethod());
            }
        }
        for (Function<UserSession, Map.Entry<String, List<String>>> f : httpSpec.getHeaders()) {
            Map.Entry<String, List<String>> headerEntry = f.apply(userSession);
            builder = (RequestBuilder)builder.addHeader((CharSequence)headerEntry.getKey(), (Iterable)headerEntry.getValue());
        }
        for (Function<UserSession, Map.Entry<String, List<String>>> f : httpSpec.getQueryParameters()) {
            Map.Entry<String, List<String>> paramEntry = f.apply(userSession);
            builder = (RequestBuilder)builder.addQueryParam(paramEntry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)paramEntry.getValue()));
        }
        if (httpSpec.isAuth()) {
            builder = this.handleAuth(userSession, builder);
        }
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RequestBuilder handleAuth(UserSession userSession, RequestBuilder builder) {
        User user = userSession.getUser();
        if (!(user instanceof OAuthUser)) return builder;
        OAuthService authService = ((OAuthUser)user).getOAuthService();
        if (SimulationConfig.isServiceAuthenticationEnabled()) {
            String serviceAccessToken = authService.getAccessToken();
            String userToken = ((OAuthUser)user).getAccessToken();
            if (USER.equals(SimulationConfig.getBearerType())) {
                builder = (RequestBuilder)builder.addHeader((CharSequence)HEADER_AUTHORIZATION, BEARER + userToken);
                return (RequestBuilder)builder.addHeader((CharSequence)SimulationConfig.getHeaderName(), serviceAccessToken);
            }
            if (!SERVICE.equals(SimulationConfig.getBearerType())) throw new UnknownTokenTypeException(SimulationConfig.getBearerType());
            builder = (RequestBuilder)builder.addHeader((CharSequence)HEADER_AUTHORIZATION, BEARER + serviceAccessToken);
            return (RequestBuilder)builder.addHeader((CharSequence)SimulationConfig.getHeaderName(), userToken);
        }
        String token = ((OAuthUser)user).getAccessToken();
        return (RequestBuilder)builder.addHeader((CharSequence)HEADER_AUTHORIZATION, BEARER + token);
    }
}

