/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.ConfigurableDsl;
import io.ryos.rhino.sdk.dsl.LoadDsl;
import io.ryos.rhino.sdk.specs.ConditionalSpecWrapper;
import io.ryos.rhino.sdk.specs.LoopBuilder;
import io.ryos.rhino.sdk.specs.LoopSpecImpl;
import io.ryos.rhino.sdk.specs.MapperBuilder;
import io.ryos.rhino.sdk.specs.MapperSpecImpl;
import io.ryos.rhino.sdk.specs.Spec;
import io.ryos.rhino.sdk.specs.WaitSpecImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ConnectableDsl
implements LoadDsl,
ConfigurableDsl {
    private Duration pause;
    private String testName;
    private final List<Spec> executableFunctions = new ArrayList<Spec>();

    @Override
    public ConnectableDsl wait(Duration duration) {
        this.executableFunctions.add(new WaitSpecImpl(duration));
        return this;
    }

    @Override
    public ConfigurableDsl run(Spec spec) {
        this.executableFunctions.add(spec);
        return this;
    }

    @Override
    public <R, T> ConfigurableDsl map(MapperBuilder<R, T> mapper) {
        this.executableFunctions.add(new MapperSpecImpl<R, T>(mapper));
        return this;
    }

    @Override
    public <E, R extends Iterable<E>> ConfigurableDsl forEach(LoopBuilder<E, R> loopBuilder) {
        this.executableFunctions.add(new LoopSpecImpl<E, R>(loopBuilder));
        return this;
    }

    @Override
    public ConfigurableDsl runIf(Predicate<UserSession> predicate, Spec spec) {
        this.executableFunctions.add(new ConditionalSpecWrapper(spec, predicate));
        return this;
    }

    public LoadDsl withName(String testName) {
        this.executableFunctions.forEach((? super T s) -> s.setTestName(testName));
        this.testName = testName;
        return this;
    }

    public String getName() {
        return this.testName;
    }

    public List<Spec> getSpecs() {
        return this.executableFunctions;
    }
}

