/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.data;

import io.ryos.rhino.sdk.data.ContextImpl;
import io.ryos.rhino.sdk.data.SimulationSession;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.users.data.OAuthUser;
import io.ryos.rhino.sdk.users.data.User;
import java.util.Optional;

public class UserSessionImpl
extends ContextImpl
implements UserSession {
    private final User user;
    private SimulationSession simulationSession;

    public UserSessionImpl(User user) {
        this.user = user;
        this.simulationSession = new SimulationSession(this);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Optional<String> getUserToken() {
        if (this.user instanceof OAuthUser) {
            return Optional.ofNullable(((OAuthUser)this.user).getAccessToken());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getRefreshToken() {
        if (this.user instanceof OAuthUser) {
            return Optional.ofNullable(((OAuthUser)this.user).getRefreshToken());
        }
        return Optional.empty();
    }

    @Override
    public SimulationSession getSimulationSession() {
        return this.simulationSession;
    }
}

