/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.GrafanaInfo;
import io.ryos.rhino.sdk.RampupInfo;
import io.ryos.rhino.sdk.SimulationJobsScanner;
import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.ThrottlingInfo;
import io.ryos.rhino.sdk.annotations.After;
import io.ryos.rhino.sdk.annotations.Before;
import io.ryos.rhino.sdk.annotations.CleanUp;
import io.ryos.rhino.sdk.annotations.Dsl;
import io.ryos.rhino.sdk.annotations.Grafana;
import io.ryos.rhino.sdk.annotations.Influx;
import io.ryos.rhino.sdk.annotations.Logging;
import io.ryos.rhino.sdk.annotations.Prepare;
import io.ryos.rhino.sdk.annotations.RampUp;
import io.ryos.rhino.sdk.annotations.Runner;
import io.ryos.rhino.sdk.annotations.Scenario;
import io.ryos.rhino.sdk.annotations.Simulation;
import io.ryos.rhino.sdk.annotations.Throttle;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.ConnectableDsl;
import io.ryos.rhino.sdk.dsl.LoadDsl;
import io.ryos.rhino.sdk.exceptions.RepositoryNotFoundException;
import io.ryos.rhino.sdk.exceptions.SimulationNotFoundException;
import io.ryos.rhino.sdk.exceptions.SpecificationNotFoundException;
import io.ryos.rhino.sdk.runners.DefaultSimulationRunner;
import io.ryos.rhino.sdk.runners.ReactiveHttpSimulationRunner;
import io.ryos.rhino.sdk.users.repositories.DefaultUserRepositoryFactory;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import io.ryos.rhino.sdk.users.repositories.UserRepositoryFactory;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationJobsScannerImpl
implements SimulationJobsScanner {
    private static final Logger LOG = LogManager.getLogger(SimulationJobsScannerImpl.class);
    private static final String DOT = ".";

    @Override
    public List<SimulationMetadata> scan(String forSimulation, String ... inPackages) {
        Objects.requireNonNull(inPackages, "inPackages must not be null.");
        Objects.requireNonNull(forSimulation, "forSimulation must not be null.");
        return Arrays.stream(inPackages).map(p -> p.replace(DOT, File.separator)).flatMap(p -> this.scanBenchmarkClassesIn((String)p).stream().filter(a -> forSimulation.equals(this.getSimulationName((Class)a)))).map(this::createBenchmarkJob).collect(Collectors.toList());
    }

    private List<Class> scanBenchmarkClassesIn(String path) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(path);
            if (resource == null) {
                return Collections.emptyList();
            }
            if (this.isJarFile(resource)) {
                return this.getBenchmarkClassesFromJar(resource, path);
            }
            URL resourceURL = Optional.ofNullable(this.getClass().getClassLoader().getResource(path)).orElseThrow();
            File[] files = new File(resourceURL.toURI()).listFiles();
            if (files != null) {
                return Arrays.stream(files).filter(File::isFile).map(File::getName).map(f -> this.buildClassNameFrom(path, (String)f)).map(this::getClassFor).filter(this::isBenchmarkClass).collect(Collectors.toList());
            }
        }
        catch (URISyntaxException e) {
            LOG.error("URL syntax not valid.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<Class> getBenchmarkClassesFromJar(URL resource, String inPath) {
        ArrayList<Class> result = new ArrayList<Class>();
        try {
            JarURLConnection urlConnection = (JarURLConnection)new URL(resource.toExternalForm()).openConnection();
            Enumeration<JarEntry> entries = urlConnection.getJarFile().entries();
            while (entries.hasMoreElements()) {
                String className;
                Class classFor;
                JarEntry jarEntry = entries.nextElement();
                String jarEntryName = jarEntry.getRealName();
                if (!jarEntryName.contains(inPath) || !jarEntryName.endsWith(".class") || !this.isBenchmarkClass(classFor = this.getClassFor(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(DOT)).replace(File.separator, DOT)))) continue;
                result.add(classFor);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot scan the JAR file.", (Throwable)e);
        }
        return result;
    }

    private boolean isJarFile(URL resource) {
        String resourceURL = resource.toExternalForm();
        return resourceURL != null && resourceURL.contains(".jar!");
    }

    private String buildClassNameFrom(String path, String className) {
        return path.replace(File.separator, DOT) + DOT + className.substring(0, className.indexOf(DOT));
    }

    private boolean isBenchmarkClass(Class clazz) {
        return Arrays.stream(clazz.getDeclaredAnnotations()).anyMatch(f -> f instanceof Simulation);
    }

    private String getSimulationName(Class clazz) {
        return Arrays.stream(clazz.getDeclaredAnnotations()).filter(f -> f instanceof Simulation).findFirst().map(s -> ((Simulation)s).name()).orElse(null);
    }

    private Class getClassFor(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private SimulationMetadata createBenchmarkJob(Class clazz) {
        Simulation simAnnotation = clazz.getDeclaredAnnotation(Simulation.class);
        Optional<io.ryos.rhino.sdk.annotations.UserRepository> repoAnnotation = Optional.ofNullable(clazz.getDeclaredAnnotation(io.ryos.rhino.sdk.annotations.UserRepository.class));
        Runner runnerAnnotation = clazz.getDeclaredAnnotation(Runner.class);
        RampUp rampUpAnnotation = clazz.getDeclaredAnnotation(RampUp.class);
        RampupInfo rampupInfo = null;
        if (rampUpAnnotation != null) {
            int duration = simAnnotation.durationInMins();
            if (rampUpAnnotation.durationInMins() >= 0) {
                duration = rampUpAnnotation.durationInMins();
            }
            rampupInfo = new RampupInfo(rampUpAnnotation.startRps(), rampUpAnnotation.targetRps(), Duration.ofMinutes(duration));
        }
        Throttle throttlingAnnotation = clazz.getDeclaredAnnotation(Throttle.class);
        ThrottlingInfo throttlingInfo = null;
        if (throttlingAnnotation != null) {
            int duration = simAnnotation.durationInMins();
            if (throttlingAnnotation.durationInMins() >= 0) {
                duration = throttlingAnnotation.durationInMins();
            }
            throttlingInfo = new ThrottlingInfo(throttlingAnnotation.rps(), Duration.ofMinutes(duration));
        }
        boolean enableInflux = clazz.getDeclaredAnnotation(Influx.class) != null;
        Grafana grafanaAnnotation = clazz.getDeclaredAnnotation(Grafana.class);
        GrafanaInfo grafanaInfo = null;
        if (grafanaAnnotation != null) {
            grafanaInfo = new GrafanaInfo(grafanaAnnotation.dashboard(), grafanaAnnotation.name());
        }
        List<io.ryos.rhino.sdk.data.Scenario> scenarioMethods = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(a -> a instanceof Scenario)).map(s -> new io.ryos.rhino.sdk.data.Scenario(s.getDeclaredAnnotation(Scenario.class).name(), (Method)s)).collect(Collectors.toList());
        Object testInstance = ReflectionUtils.instanceOf(clazz).orElseThrow();
        List<LoadDsl> dsls = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(a -> a instanceof Dsl)).map(s -> new Pair<String, LoadDsl>(s.getDeclaredAnnotation(Dsl.class).name(), (LoadDsl)ReflectionUtils.executeMethod(s, testInstance, new Object[0]))).map(p -> {
            LoadDsl loadDsl = (LoadDsl)p.getSecond();
            if (loadDsl instanceof ConnectableDsl) {
                return ((ConnectableDsl)loadDsl).withName((String)p.getFirst());
            }
            return loadDsl;
        }).collect(Collectors.toList());
        if (scenarioMethods.isEmpty() && this.isBlockingSimulation(runnerAnnotation)) {
            throw new SimulationNotFoundException(clazz.getName());
        }
        if (dsls.isEmpty() && this.isReactiveSimulation(runnerAnnotation)) {
            throw new SpecificationNotFoundException(clazz.getName());
        }
        Logging loggingAnnotation = clazz.getDeclaredAnnotation(Logging.class);
        String logger = Optional.ofNullable(loggingAnnotation).map(Logging::file).orElse(null);
        UserRepository<UserSession> userRepo = repoAnnotation.map(this::createUserRepository).orElse(new DefaultUserRepositoryFactory().create());
        return new SimulationMetadata.Builder().withSimulationClass(clazz).withUserRepository(userRepo).withRunner(runnerAnnotation != null ? runnerAnnotation.clazz() : DefaultSimulationRunner.class).withSimulation(simAnnotation.name()).withDuration(Duration.ofMinutes(simAnnotation.durationInMins())).withUserRegion(simAnnotation.userRegion()).withInjectUser(simAnnotation.maxNumberOfUsers()).withLogWriter(this.validateLogFile(logger)).withInflux(enableInflux).withPrepare(this.findStaticMethodWith(clazz, Prepare.class).orElse(null)).withCleanUp(this.findStaticMethodWith(clazz, CleanUp.class).orElse(null)).withBefore(this.findMethodWith(clazz, Before.class).orElse(null)).withAfter(this.findMethodWith(clazz, After.class).orElse(null)).withScenarios(scenarioMethods).withDsls(dsls).withTestInstance(testInstance).withThrottling(throttlingInfo).withRampUp(rampupInfo).withGrafana(grafanaInfo).build();
    }

    private boolean isBlockingSimulation(Runner runnerAnnotation) {
        return runnerAnnotation == null || runnerAnnotation.clazz().equals(DefaultSimulationRunner.class);
    }

    private boolean isReactiveSimulation(Runner runnerAnnotation) {
        return runnerAnnotation != null && runnerAnnotation.clazz().equals(ReactiveHttpSimulationRunner.class);
    }

    private String validateLogFile(String logFile) {
        if (logFile == null) {
            return null;
        }
        File simFile = new File(logFile);
        try {
            boolean newFile = simFile.createNewFile();
            if (!newFile && !simFile.canWrite()) {
                throw new IOException("Not sufficient permissions to write the simulation file: " + simFile);
            }
        }
        catch (IOException e) {
            System.err.println(String.format("! Simulation log file is invalid: \"%s\"", simFile));
            System.exit(-1);
        }
        return logFile;
    }

    private UserRepository createUserRepository(io.ryos.rhino.sdk.annotations.UserRepository userRepository) {
        Class<? extends UserRepositoryFactory> factory = userRepository.factory();
        long loginDelay = userRepository.delay();
        try {
            Constructor<? extends UserRepositoryFactory> factoryConstructor = factory.getConstructor(Long.TYPE);
            UserRepositoryFactory userRepositoryFactory = factoryConstructor.newInstance(loginDelay);
            return userRepositoryFactory.create();
        }
        catch (NoSuchMethodException nsme) {
            return this.createWithDefaultConstructor(factory);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error((Object)e);
            throw new RepositoryNotFoundException();
        }
    }

    private UserRepository createWithDefaultConstructor(Class<? extends UserRepositoryFactory> factory) {
        try {
            return factory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private <T extends Annotation> Optional<Method> findMethodWith(Class<?> clazz, Class<T> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(annotation::isInstance)).findFirst();
    }

    private <T extends Annotation> Optional<Method> findStaticMethodWith(Class<?> clazz, Class<T> annotation) {
        return Arrays.stream(clazz.getMethods()).filter(m -> Arrays.stream(m.getAnnotations()).anyMatch(annotation::isInstance)).findFirst().map(Method::getName).map(name -> this.getStaticMethod(clazz, (String)name));
    }

    private Method getStaticMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, UserSession.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }
}

