/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.Application;
import io.ryos.rhino.sdk.Simulation;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.SimulationJobsScanner;
import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.data.Context;
import io.ryos.rhino.sdk.data.ContextImpl;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.exceptions.ProfileNotFoundException;
import io.ryos.rhino.sdk.exceptions.SimulationNotFoundException;
import io.ryos.rhino.sdk.runners.SimulationRunner;
import io.ryos.rhino.sdk.utils.Environment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationImpl
implements Simulation {
    private static final Logger LOG = LoggerFactory.getLogger(SimulationImpl.class);
    private static final String KEY_PROFILE = "profile";
    private static final String JOB = "job";
    private List<SimulationRunner> simulationRunners;

    SimulationImpl(String path, String simulationName) {
        try {
            Application.showBranding();
            Environment environment = this.getEnvironment();
            SimulationConfig simulationConfig = SimulationConfig.newInstance(path, environment);
            List<SimulationMetadata> jobs = SimulationJobsScanner.create().scan(simulationName, simulationConfig.getPackageToScan());
            this.simulationRunners = jobs.stream().map(simulation -> new Pair<SimulationMetadata, ContextImpl>((SimulationMetadata)simulation, this.getContext((SimulationMetadata)simulation))).map(pair -> this.getRunner(((SimulationMetadata)pair.getFirst()).getRunner(), (Context)pair.getSecond())).collect(Collectors.toList());
        }
        catch (Throwable pe) {
            LOG.error("Cannot start application", pe);
            System.exit(-1);
        }
    }

    private SimulationRunner getRunner(Class<? extends SimulationRunner> runnerClass, Context context) {
        try {
            Constructor<? extends SimulationRunner> declaredConstructor = runnerClass.getDeclaredConstructor(Context.class);
            return declaredConstructor.newInstance(context);
        }
        catch (NoSuchMethodException declaredConstructor) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("Cannot get runner implementation", (Throwable)e);
        }
        throw new IllegalArgumentException("Runner class: " + runnerClass.getName() + " is invalid.");
    }

    private Environment getEnvironment() {
        String profile = System.getProperty(KEY_PROFILE, Environment.DEV.toString());
        try {
            return Environment.valueOf(profile.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ExceptionUtils.rethrow(e, ProfileNotFoundException.class, "ERROR: Environment profile '" + profile + "' not found. Dev, Stage, Prod are known environment profiles. Pass a valid VM argument e.g -Dprofile=dev");
            return null;
        }
    }

    private ContextImpl getContext(SimulationMetadata job) {
        ContextImpl context = new ContextImpl();
        context.add(JOB, job);
        return context;
    }

    @Override
    public void start() {
        try {
            if (this.simulationRunners.isEmpty()) {
                throw new SimulationNotFoundException("ERROR: No simulation found in '" + SimulationConfig.getPackage() + "'.");
            }
            this.simulationRunners.forEach(SimulationRunner::start);
        }
        catch (Throwable t) {
            LOG.error("Cannot start application", t);
            System.exit(-1);
        }
    }

    @Override
    public void stop() {
        LOG.info("Stopping simulation...");
        this.simulationRunners.forEach(SimulationRunner::stop);
    }
}

